/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.Locale;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.ThrowableItemEntity;
import org.geysermc.geyser.entity.type.living.animal.farm.TemperatureVariantAnimal;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;

public class ThrowableEggEntity
extends ThrowableItemEntity {
    private GeyserItemStack itemStack;

    public ThrowableEggEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void addAdditionalSpawnData(AddEntityPacket addEntityPacket) {
        this.propertyManager.add("minecraft:climate_variant", "temperate");
        this.propertyManager.applyIntProperties(addEntityPacket.getProperties().getIntProperties());
    }

    @Override
    public void setItem(EntityMetadata<ItemStack, ?> entityMetadata) {
        GeyserItemStack stack = GeyserItemStack.from(entityMetadata.getValue());
        this.propertyManager.add("minecraft:climate_variant", ThrowableEggEntity.getVariantOrFallback(this.session, stack));
        this.updateBedrockEntityProperties();
        this.itemStack = stack;
    }

    private static String getVariantOrFallback(GeyserSession session, GeyserItemStack stack) {
        Holder<Key> holder = stack.getComponent(DataComponentTypes.CHICKEN_VARIANT);
        if (holder != null) {
            Key chickenVariant = holder.getOrCompute(id -> JavaRegistries.CHICKEN_VARIANT.key(session, id));
            for (TemperatureVariantAnimal.BuiltInVariant variant : TemperatureVariantAnimal.BuiltInVariant.values()) {
                if (!chickenVariant.asMinimalString().equalsIgnoreCase(variant.name())) continue;
                return chickenVariant.asMinimalString().toLowerCase(Locale.ROOT);
            }
        }
        return TemperatureVariantAnimal.BuiltInVariant.TEMPERATE.toBedrock();
    }

    public GeyserItemStack getItemStack() {
        return this.itemStack;
    }
}

