/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.util.http.responsehandler;

import java.io.IOException;
import net.lenni0451.commons.gson.GsonParser;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.constants.ContentTypes;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.raphimc.minecraftauth.util.http.exception.InformativeHttpRequestException;

public interface JsonHttpResponseHandler<R>
extends HttpResponseHandler<R> {
    @Override
    default public R handle(HttpResponse response) throws IOException {
        String content = response.getContent().getAsString();
        if (content.isEmpty() && response.getStatusCode() == 204) {
            return null;
        }
        if (content.isEmpty() && response.getStatusCode() >= 300) {
            throw new InformativeHttpRequestException(response, "Empty response");
        }
        if (!response.getContent().getType().getMimeType().equals(ContentTypes.APPLICATION_JSON.getMimeType())) {
            throw new InformativeHttpRequestException(response, "Wrong content type");
        }
        GsonObject json = GsonParser.parse(content).asObject();
        if (response.getStatusCode() >= 300) {
            this.handleError(response, json);
            throw new InformativeHttpRequestException(response, content);
        }
        return this.handle(response, json);
    }

    public R handle(HttpResponse var1, GsonObject var2) throws IOException;

    public void handleError(HttpResponse var1, GsonObject var2) throws IOException;
}

