/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.xbl.request;

import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.time.Instant;
import java.util.Base64;
import java.util.Optional;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.requests.HttpContentRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.util.CryptUtil;
import net.raphimc.minecraftauth.util.TimeUtil;

public abstract class SignedXblPostRequest
extends PostRequest {
    public SignedXblPostRequest(String url) throws MalformedURLException {
        super(url);
    }

    public SignedXblPostRequest(URL url) {
        super(url);
    }

    protected void appendSignatureHeader(ECPrivateKey privateKey) {
        long windowsTimestamp = (Instant.now().plus(TimeUtil.getClientTimeOffset()).getEpochSecond() + 11644473600L) * 10000000L;
        ByteArrayOutputStream headerData = new ByteArrayOutputStream();
        try {
            HttpContent content;
            ByteArrayOutputStream signatureContent = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(signatureContent);
            data.writeInt(1);
            data.writeByte(0);
            data.writeLong(windowsTimestamp);
            data.writeByte(0);
            data.write(this.getMethod().getBytes(StandardCharsets.UTF_8));
            data.writeByte(0);
            data.write((this.getURL().getPath() + (this.getURL().getQuery() != null ? this.getURL().getQuery() : "")).getBytes(StandardCharsets.UTF_8));
            data.writeByte(0);
            Optional<String> authorizationHeader = this.getFirstHeader("Authorization");
            if (authorizationHeader.isPresent()) {
                data.write(authorizationHeader.get().getBytes(StandardCharsets.UTF_8));
            }
            data.writeByte(0);
            if (this instanceof HttpContentRequest && (content = this.getContent()) != null) {
                data.write(content.getAsBytes());
            }
            data.writeByte(0);
            data = new DataOutputStream(headerData);
            data.writeInt(1);
            data.writeLong(windowsTimestamp);
            data.write(CryptUtil.signSha256InP1363Format(privateKey, signatureContent.toByteArray()));
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not sign request", e);
        }
        this.appendHeader("Signature", Base64.getEncoder().encodeToString(headerData.toByteArray()));
    }

    protected JsonObject getProofKey(ECPublicKey publicKey) {
        JsonObject proofKey = new JsonObject();
        proofKey.addProperty("kty", "EC");
        proofKey.addProperty("alg", "ES256");
        proofKey.addProperty("crv", "P-256");
        proofKey.addProperty("use", "sig");
        proofKey.addProperty("x", this.encodeEcCoordinate(publicKey.getParams().getCurve().getField().getFieldSize(), publicKey.getW().getAffineX()));
        proofKey.addProperty("y", this.encodeEcCoordinate(publicKey.getParams().getCurve().getField().getFieldSize(), publicKey.getW().getAffineY()));
        return proofKey;
    }

    private String encodeEcCoordinate(int fieldSize, BigInteger coordinate) {
        int bytesToOutput;
        byte[] notPadded = this.bigIntegerToByteArray(coordinate);
        if (notPadded.length >= (bytesToOutput = (fieldSize + 7) / 8)) {
            return Base64.getUrlEncoder().withoutPadding().encodeToString(notPadded);
        }
        byte[] padded = new byte[bytesToOutput];
        System.arraycopy(notPadded, 0, padded, bytesToOutput - notPadded.length, notPadded.length);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(padded);
    }

    private byte[] bigIntegerToByteArray(BigInteger bigInteger) {
        int bitlen = bigInteger.bitLength();
        bitlen = bitlen + 7 >> 3 << 3;
        byte[] bigBytes = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        int startSrc = 0;
        int len = bigBytes.length;
        if (bigInteger.bitLength() % 8 == 0) {
            startSrc = 1;
            --len;
        }
        int startDst = bitlen / 8 - len;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, len);
        return resizedBytes;
    }
}

