/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.imaginary;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.imaginary.Complexf;
import org.cloudburstmc.math.imaginary.Imaginary;
import org.cloudburstmc.math.imaginary.Imaginaryd;
import org.cloudburstmc.math.imaginary.Quaterniond;
import org.cloudburstmc.math.vector.Vector2d;
import org.cloudburstmc.math.vector.Vector3d;

@ParametersAreNonnullByDefault
public abstract class Complexd
implements Imaginaryd,
Comparable<Complexd>,
Serializable,
Cloneable {
    public static final Complexd ZERO = Complexd.from(0.0f, 0.0f);
    public static final Complexd IDENTITY = Complexd.from(1.0f, 0.0f);

    public abstract double getX();

    public abstract double getY();

    @Nonnull
    public Complexd add(Complexd c) {
        return this.add(c.getX(), c.getY());
    }

    @Nonnull
    public Complexd add(float x, float y) {
        return this.add((double)x, (double)y);
    }

    @Nonnull
    public abstract Complexd add(double var1, double var3);

    @Nonnull
    public Complexd sub(Complexd c) {
        return this.sub(c.getX(), c.getY());
    }

    @Nonnull
    public Complexd sub(float x, float y) {
        return this.sub((double)x, (double)y);
    }

    @Nonnull
    public abstract Complexd sub(double var1, double var3);

    @Nonnull
    public Complexd mul(float a) {
        return this.mul((double)a);
    }

    @Override
    @Nonnull
    public abstract Complexd mul(double var1);

    @Nonnull
    public Complexd mul(Complexd c) {
        return this.mul(c.getX(), c.getY());
    }

    @Nonnull
    public Complexd mul(float x, float y) {
        return this.mul((double)x, (double)y);
    }

    @Nonnull
    public abstract Complexd mul(double var1, double var3);

    @Nonnull
    public Complexd div(float a) {
        return this.div((double)a);
    }

    @Override
    @Nonnull
    public abstract Complexd div(double var1);

    @Nonnull
    public Complexd div(Complexd c) {
        return this.div(c.getX(), c.getY());
    }

    @Nonnull
    public Complexd div(float x, float y) {
        return this.div((double)x, (double)y);
    }

    @Nonnull
    public abstract Complexd div(double var1, double var3);

    public double dot(Complexd c) {
        return this.dot(c.getX(), c.getY());
    }

    public double dot(float x, float y) {
        return this.dot((double)x, (double)y);
    }

    public double dot(double x, double y) {
        return this.getX() * x + this.getY() * y;
    }

    @Nonnull
    public Vector2d rotate(Vector2d v) {
        return this.rotate(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2d rotate(float x, float y) {
        return this.rotate((double)x, (double)y);
    }

    @Nonnull
    public Vector2d rotate(double x, double y) {
        double length = this.length();
        if (Math.abs(length) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot rotate by the zero complex");
        }
        double nx = this.getX() / length;
        double ny = this.getY() / length;
        return Vector2d.from(x * nx - y * ny, y * nx + x * ny);
    }

    @Nonnull
    public Vector2d getDirection() {
        return Vector2d.from(this.getX(), this.getY()).normalize();
    }

    public double getAngleRad() {
        return TrigMath.atan2(this.getY(), this.getX());
    }

    public double getAngleDeg() {
        return Math.toDegrees(this.getAngleRad());
    }

    @Override
    @Nonnull
    public abstract Complexd conjugate();

    @Override
    @Nonnull
    public abstract Complexd invert();

    @Override
    public double lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    @Override
    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public abstract Complexd normalize();

    @Nonnull
    public Quaterniond toQuaternion() {
        return this.toQuaternion(Vector3d.UNIT_Z);
    }

    @Nonnull
    public Quaterniond toQuaternion(Vector3d axis) {
        return this.toQuaternion(axis.getX(), axis.getY(), axis.getZ());
    }

    @Nonnull
    public Quaterniond toQuaternion(float x, float y, float z) {
        return this.toQuaternion((double)x, (double)y, (double)z);
    }

    @Nonnull
    public Quaterniond toQuaternion(double x, double y, double z) {
        return Quaterniond.fromAngleRadAxis(this.getAngleRad(), x, y, z);
    }

    @Override
    @Nonnull
    public Complexf toFloat() {
        return Complexf.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Complexd toDouble() {
        return Complexd.from(this.getX(), this.getY());
    }

    @Override
    public int compareTo(Complexd c) {
        return (int)Math.signum(this.lengthSquared() - c.lengthSquared());
    }

    @Nonnull
    public Complexd clone() {
        return Complexd.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ")";
    }

    @Nonnull
    public static Complexd fromReal(double x) {
        return Imaginary.createComplexd(x, 0.0);
    }

    @Nonnull
    public static Complexd fromImaginary(double y) {
        return Imaginary.createComplexd(0.0, y);
    }

    @Nonnull
    public static Complexd from(Complexd c) {
        return Complexd.from(c.getX(), c.getY());
    }

    @Nonnull
    public static Complexd from(float x, float y) {
        return Complexd.from((double)x, (double)y);
    }

    @Nonnull
    public static Complexd from(double x, double y) {
        return Imaginary.createComplexd(x, y);
    }

    @Nonnull
    public static Complexd fromRotationTo(Vector2d from, Vector2d to) {
        return Complexd.fromAngleRad(TrigMath.acos(from.dot(to) / (from.length() * to.length())));
    }

    @Nonnull
    public static Complexd fromRotationTo(Vector3d from, Vector3d to) {
        return Complexd.fromAngleRad(TrigMath.acos(from.dot(to) / (from.length() * to.length())));
    }

    @Nonnull
    public static Complexd fromAngleDeg(float angle) {
        return Complexd.fromAngleRad(Math.toRadians(angle));
    }

    @Nonnull
    public static Complexd fromAngleRad(float angle) {
        return Complexd.fromAngleRad((double)angle);
    }

    @Nonnull
    public static Complexd fromAngleDeg(double angle) {
        return Complexd.fromAngleRad(Math.toRadians(angle));
    }

    @Nonnull
    public static Complexd fromAngleRad(double angle) {
        return Complexd.from(TrigMath.cos(angle), TrigMath.sin(angle));
    }
}

