/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.bukkit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.UnsafeValues;

public final class VersionCheckUtils {
    public static int getServerProtocol(Logger logger, boolean debug) {
        try {
            UnsafeValues.class.getMethod("getProtocolVersion", new Class[0]);
            return Bukkit.getUnsafe().getProtocolVersion();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class<?> sharedConstants;
            try {
                sharedConstants = Class.forName("net.minecraft.SharedConstants");
            }
            catch (ClassNotFoundException e) {
                String prefix = Bukkit.getServer().getClass().getPackage().getName().replace("org.bukkit.craftbukkit", "net.minecraft.server");
                try {
                    sharedConstants = Class.forName(prefix + ".SharedConstants");
                }
                catch (ClassNotFoundException e2) {
                    return -1;
                }
            }
            for (Method method : sharedConstants.getMethods()) {
                int protocolVersion;
                if (method.getReturnType() != Integer.TYPE || !Modifier.isStatic(method.getModifiers())) continue;
                try {
                    protocolVersion = (Integer)method.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    logger.warning("Could not determine server version! This is safe to ignore, but please report to the developers: " + e.getMessage());
                    if (debug) {
                        e.printStackTrace();
                    }
                    return -1;
                }
                return protocolVersion;
            }
            return -1;
        }
    }

    private VersionCheckUtils() {
    }
}

