/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot;

import com.viaversion.viaversion.api.Via;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.bukkit.Bukkit;
import org.bukkit.UnsafeValues;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.text.GeyserLocale;

public final class GeyserSpigotVersionChecker {
    private static final String VIAVERSION_DOWNLOAD_URL = "https://ci.viaversion.com/job/ViaVersion/";

    public static void checkForSupportedProtocol(GeyserLogger logger, boolean viaversion) {
        if (viaversion) {
            GeyserSpigotVersionChecker.checkViaVersionSupportedVersions(logger);
            return;
        }
        try {
            UnsafeValues.class.getMethod("getProtocolVersion", new Class[0]);
            if (Bukkit.getUnsafe().getProtocolVersion() != GameProtocol.getJavaProtocolVersion()) {
                GeyserSpigotVersionChecker.sendOutdatedMessage(logger);
            }
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class<?> sharedConstants;
            try {
                sharedConstants = Class.forName("net.minecraft.SharedConstants");
            }
            catch (ClassNotFoundException e) {
                String prefix = Bukkit.getServer().getClass().getPackage().getName().replace("org.bukkit.craftbukkit", "net.minecraft.server");
                try {
                    sharedConstants = Class.forName(prefix + ".SharedConstants");
                }
                catch (ClassNotFoundException e2) {
                    GeyserSpigotVersionChecker.sendOutdatedMessage(logger);
                    return;
                }
            }
            for (Method method : sharedConstants.getMethods()) {
                int protocolVersion;
                if (method.getReturnType() != Integer.TYPE || !Modifier.isStatic(method.getModifiers())) continue;
                try {
                    protocolVersion = (Integer)method.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    logger.warning("Could not determine server version! This is safe to ignore, but please report to the developers: " + e.getMessage());
                    if (logger.isDebug()) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (protocolVersion != GameProtocol.getJavaProtocolVersion()) {
                    GeyserSpigotVersionChecker.sendOutdatedMessage(logger);
                }
                return;
            }
            GeyserSpigotVersionChecker.sendOutdatedMessage(logger);
            return;
        }
    }

    private static void checkViaVersionSupportedVersions(GeyserLogger logger) {
        Via.getPlatform().runSync(() -> {
            if (Via.getAPI().getSupportedVersions().contains(GameProtocol.getJavaProtocolVersion())) {
                return;
            }
            if (Via.getAPI().getFullSupportedVersions().contains(GameProtocol.getJavaProtocolVersion())) {
                logger.warning(GeyserLocale.getLocaleStringLog("geyser.bootstrap.viaversion.blocked", GameProtocol.getAllSupportedJavaVersions()));
                return;
            }
            GeyserSpigotVersionChecker.sendOutdatedViaVersionMessage(logger);
        });
    }

    public static void sendOutdatedViaVersionMessage(GeyserLogger logger) {
        logger.warning(GeyserLocale.getLocaleStringLog("geyser.bootstrap.viaversion.too_old", VIAVERSION_DOWNLOAD_URL));
    }

    private static void sendOutdatedMessage(GeyserLogger logger) {
        logger.warning(GeyserLocale.getLocaleStringLog("geyser.bootstrap.no_supported_protocol", GameProtocol.getAllSupportedJavaVersions(), VIAVERSION_DOWNLOAD_URL));
    }

    private GeyserSpigotVersionChecker() {
    }
}

