/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.net.InetAddress;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.objectmapping.meta.Processor;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.serialize.SerializationException;

public class AsteriskSerializer
implements JsonSerializer<String> {
    public static final String[] NON_SENSITIVE_ADDRESSES = new String[]{"", "0.0.0.0", "localhost", "127.0.0.1", "auto", "unknown"};
    public static boolean showSensitive = false;
    public static Processor.Factory<Asterisk, String> CONFIGURATE_SERIALIZER = (data, fieldType) -> (value, destination) -> {
        if (showSensitive || !AsteriskSerializer.isSensitiveIp(value)) {
            return;
        }
        try {
            destination.set("***");
        }
        catch (SerializationException e) {
            throw new RuntimeException("Unable to censor IP address", e);
        }
    };

    public JsonElement serialize(String src, Type typeOfSrc, JsonSerializationContext context) {
        if (showSensitive || !AsteriskSerializer.isSensitiveIp(src)) {
            return new JsonPrimitive(src);
        }
        return new JsonPrimitive("***");
    }

    private static boolean isSensitiveIp(String ip) {
        for (String address : NON_SENSITIVE_ADDRESSES) {
            if (!address.equalsIgnoreCase(ip)) continue;
            return false;
        }
        try {
            InetAddress address = InetAddress.getByName(ip);
            if (address.isSiteLocalAddress() || address.isLoopbackAddress()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Asterisk {
    }
}

