/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.entity.vehicle.BoostableVehicleComponent;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class PigEntity
extends AnimalEntity
implements Tickable,
ClientVehicle {
    private final BoostableVehicleComponent<PigEntity> vehicleComponent = new BoostableVehicleComponent<PigEntity>(this, 1.0f);

    public PigEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void addAdditionalSpawnData(AddEntityPacket addEntityPacket) {
        this.propertyManager.add("minecraft:climate_variant", "temperate");
        this.propertyManager.applyIntProperties(addEntityPacket.getProperties().getIntProperties());
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.PIG_FOOD;
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.canEat(itemInHand) && this.getFlag(EntityFlag.SADDLED) && this.passengers.isEmpty() && !this.session.isSneaking()) {
            return InteractiveTag.MOUNT;
        }
        InteractiveTag superTag = super.testMobInteraction(hand, itemInHand);
        if (superTag != InteractiveTag.NONE) {
            return superTag;
        }
        return EntityUtils.attemptToSaddle(this, itemInHand).consumesAction() ? InteractiveTag.SADDLE : InteractiveTag.NONE;
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.canEat(itemInHand) && this.getFlag(EntityFlag.SADDLED) && this.passengers.isEmpty() && !this.session.isSneaking()) {
            return InteractionResult.SUCCESS;
        }
        InteractionResult superResult = super.mobInteract(hand, itemInHand);
        if (superResult.consumesAction()) {
            return superResult;
        }
        return EntityUtils.attemptToSaddle(this, itemInHand);
    }

    public void setBoost(IntEntityMetadata entityMetadata) {
        this.vehicleComponent.startBoost(entityMetadata.getPrimitiveValue());
    }

    @Override
    public void tick() {
        PlayerEntity player = this.getPlayerPassenger();
        if (player == null) {
            return;
        }
        if (player == this.session.getPlayerEntity()) {
            if (this.session.getPlayerInventory().isHolding(Items.CARROT_ON_A_STICK)) {
                this.vehicleComponent.tickBoost();
            }
        } else {
            ItemDefinition itemDefinition = this.session.getItemMappings().getStoredItems().carrotOnAStick().getBedrockDefinition();
            if (player.getHand().getDefinition() == itemDefinition || player.getOffhand().getDefinition() == itemDefinition) {
                this.vehicleComponent.tickBoost();
            }
        }
    }

    @Override
    public VehicleComponent<?> getVehicleComponent() {
        return this.vehicleComponent;
    }

    @Override
    public Vector2f getAdjustedInput(Vector2f input) {
        return Vector2f.UNIT_Y;
    }

    @Override
    public float getVehicleSpeed() {
        return this.vehicleComponent.getMoveSpeed() * 0.225f * this.vehicleComponent.getBoostMultiplier();
    }

    private @Nullable PlayerEntity getPlayerPassenger() {
        Object e;
        if (this.getFlag(EntityFlag.SADDLED) && !this.passengers.isEmpty() && (e = this.passengers.get(0)) instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)e;
            return playerEntity;
        }
        return null;
    }

    @Override
    public boolean isClientControlled() {
        return this.getPlayerPassenger() == this.session.getPlayerEntity() && this.session.getPlayerInventory().isHolding(Items.CARROT_ON_A_STICK);
    }
}

