/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.network.CodecProcessor;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v748.Bedrock_v748;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v766.Bedrock_v766;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v776.Bedrock_v776;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v786.Bedrock_v786;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodec;
import org.geysermc.mcprotocollib.protocol.codec.PacketCodec;

public final class GameProtocol {
    public static final BedrockCodec DEFAULT_BEDROCK_CODEC = CodecProcessor.processCodec(Bedrock_v786.CODEC.toBuilder().minecraftVersion("1.21.70").build());
    public static final List<BedrockCodec> SUPPORTED_BEDROCK_CODECS = new ArrayList<BedrockCodec>();
    private static final PacketCodec DEFAULT_JAVA_CODEC = MinecraftCodec.CODEC;

    public static @Nullable BedrockCodec getBedrockCodec(int protocolVersion) {
        for (BedrockCodec packetCodec : SUPPORTED_BEDROCK_CODECS) {
            if (packetCodec.getProtocolVersion() != protocolVersion) continue;
            return packetCodec;
        }
        return null;
    }

    public static boolean isPreWinterDrop(GeyserSession session) {
        return session.getUpstream().getProtocolVersion() == Bedrock_v748.CODEC.getProtocolVersion();
    }

    public static boolean isPreCreativeInventoryRewrite(int protocolVersion) {
        return protocolVersion < 776;
    }

    public static PacketCodec getJavaCodec() {
        return DEFAULT_JAVA_CODEC;
    }

    public static List<String> getJavaVersions() {
        return List.of(DEFAULT_JAVA_CODEC.getMinecraftVersion());
    }

    public static int getJavaProtocolVersion() {
        return DEFAULT_JAVA_CODEC.getProtocolVersion();
    }

    public static String getJavaMinecraftVersion() {
        return DEFAULT_JAVA_CODEC.getMinecraftVersion();
    }

    public static String getAllSupportedBedrockVersions() {
        StringJoiner joiner = new StringJoiner(", ");
        for (BedrockCodec packetCodec : SUPPORTED_BEDROCK_CODECS) {
            joiner.add(packetCodec.getMinecraftVersion());
        }
        return joiner.toString();
    }

    public static String getAllSupportedJavaVersions() {
        StringJoiner joiner = new StringJoiner(", ");
        for (String version : GameProtocol.getJavaVersions()) {
            joiner.add(version);
        }
        return joiner.toString();
    }

    private GameProtocol() {
    }

    static {
        SUPPORTED_BEDROCK_CODECS.add(CodecProcessor.processCodec(Bedrock_v748.CODEC.toBuilder().minecraftVersion("1.21.40 - 1.21.44").build()));
        SUPPORTED_BEDROCK_CODECS.add(CodecProcessor.processCodec(Bedrock_v766.CODEC.toBuilder().minecraftVersion("1.21.50 - 1.21.51").build()));
        SUPPORTED_BEDROCK_CODECS.add(CodecProcessor.processCodec(Bedrock_v776.CODEC.toBuilder().minecraftVersion("1.21.60 - 1.21.62").build()));
        SUPPORTED_BEDROCK_CODECS.add(DEFAULT_BEDROCK_CODEC);
    }
}

