/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v390.serializer;

import io.netty.buffer.ByteBuf;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockPacketSerializer;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.VarInts;

public class PlayerListSerializer_v390
implements BedrockPacketSerializer<PlayerListPacket> {
    public static final PlayerListSerializer_v390 INSTANCE = new PlayerListSerializer_v390();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, PlayerListPacket packet) {
        buffer.writeByte(packet.getAction().ordinal());
        VarInts.writeUnsignedInt(buffer, packet.getEntries().size());
        if (packet.getAction() == PlayerListPacket.Action.ADD) {
            for (PlayerListPacket.Entry entry : packet.getEntries()) {
                this.writeEntryBase(buffer, helper, entry);
            }
            for (PlayerListPacket.Entry entry : packet.getEntries()) {
                buffer.writeBoolean(entry.isTrustedSkin());
            }
        } else {
            for (PlayerListPacket.Entry entry : packet.getEntries()) {
                helper.writeUuid(buffer, entry.getUuid());
            }
        }
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, PlayerListPacket packet) {
        PlayerListPacket.Action action = PlayerListPacket.Action.values()[buffer.readUnsignedByte()];
        packet.setAction(action);
        int length = VarInts.readUnsignedInt(buffer);
        if (action == PlayerListPacket.Action.ADD) {
            int i;
            for (i = 0; i < length; ++i) {
                packet.getEntries().add(this.readEntryBase(buffer, helper));
            }
            for (i = 0; i < length && buffer.isReadable(); ++i) {
                packet.getEntries().get(i).setTrustedSkin(buffer.readBoolean());
            }
        } else {
            for (int i = 0; i < length; ++i) {
                packet.getEntries().add(new PlayerListPacket.Entry(helper.readUuid(buffer)));
            }
        }
    }

    protected void writeEntryBase(ByteBuf buffer, BedrockCodecHelper helper, PlayerListPacket.Entry entry) {
        helper.writeUuid(buffer, entry.getUuid());
        VarInts.writeLong(buffer, entry.getEntityId());
        helper.writeString(buffer, entry.getName());
        helper.writeString(buffer, entry.getXuid());
        helper.writeString(buffer, entry.getPlatformChatId());
        buffer.writeIntLE(entry.getBuildPlatform());
        helper.writeSkin(buffer, entry.getSkin());
        buffer.writeBoolean(entry.isTeacher());
        buffer.writeBoolean(entry.isHost());
    }

    protected PlayerListPacket.Entry readEntryBase(ByteBuf buffer, BedrockCodecHelper helper) {
        PlayerListPacket.Entry entry = new PlayerListPacket.Entry(helper.readUuid(buffer));
        entry.setEntityId(VarInts.readLong(buffer));
        entry.setName(helper.readString(buffer));
        entry.setXuid(helper.readString(buffer));
        entry.setPlatformChatId(helper.readString(buffer));
        entry.setBuildPlatform(buffer.readIntLE());
        entry.setSkin(helper.readSkin(buffer));
        entry.setTeacher(buffer.readBoolean());
        entry.setHost(buffer.readBoolean());
        return entry;
    }

    protected PlayerListSerializer_v390() {
    }
}

