/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.connection.ConnectionRequestEvent;
import org.geysermc.geyser.command.defaults.ConnectionTestCommand;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.event.type.GeyserBedrockPingEventImpl;
import org.geysermc.geyser.network.CIDRMatcher;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.network.GeyserServerInitializer;
import org.geysermc.geyser.network.netty.Bootstraps;
import org.geysermc.geyser.network.netty.handler.RakConnectionRequestHandler;
import org.geysermc.geyser.network.netty.handler.RakGeyserRateLimiter;
import org.geysermc.geyser.network.netty.handler.RakPingHandler;
import org.geysermc.geyser.network.netty.proxy.ProxyServerHandler;
import org.geysermc.geyser.ping.GeyserPingInfo;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.channel.raknet.RakChannelFactory;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.BedrockPong;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;

public final class GeyserServer {
    private static final boolean PRINT_DEBUG_PINGS = Boolean.parseBoolean(System.getProperty("Geyser.PrintPingsInDebugMode", "true"));
    private static final String PING_VERSION = GeyserServer.pingVersion();
    private static final int PING_VERSION_BYTES_LENGTH = PING_VERSION.getBytes(StandardCharsets.UTF_8).length;
    private static final int BRAND_BYTES_LENGTH = "Geyser".getBytes(StandardCharsets.UTF_8).length;
    private static final int MAGIC_RAKNET_LENGTH = 338;
    private static final Transport TRANSPORT = GeyserServer.compatibleTransport();
    private static final int SHUTDOWN_QUIET_PERIOD_MS = 100;
    private static final int SHUTDOWN_TIMEOUT_MS = 500;
    private final GeyserImpl geyser;
    private EventLoopGroup group;
    private EventLoopGroup childGroup;
    private final ServerBootstrap bootstrap;
    private EventLoopGroup playerGroup;
    private final ExpiringMap<InetSocketAddress, InetSocketAddress> proxiedAddresses;
    private int listenCount;
    private ChannelFuture[] bootstrapFutures;
    private int connectionAttempts = 0;
    private final int broadcastPort;

    public GeyserServer(GeyserImpl geyser, int threadCount) {
        this.geyser = geyser;
        this.listenCount = Bootstraps.isReusePortAvailable() ? Integer.getInteger("Geyser.ListenCount", 2) : 1;
        GeyserImpl.getInstance().getLogger().debug("Listen thread count: " + this.listenCount);
        this.group = TRANSPORT.eventLoopGroupFactory().apply(this.listenCount);
        this.childGroup = TRANSPORT.eventLoopGroupFactory().apply(threadCount);
        this.bootstrap = this.createBootstrap();
        if (!Bootstraps.setupBootstrap((AbstractBootstrap)this.bootstrap)) {
            this.listenCount = 1;
        }
        this.proxiedAddresses = this.geyser.getConfig().getBedrock().isEnableProxyProtocol() ? ExpiringMap.builder().expiration(31L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).build() : null;
        this.broadcastPort = geyser.getConfig().getBedrock().broadcastPort();
    }

    public CompletableFuture<Void> bind(InetSocketAddress address) {
        this.bootstrapFutures = new ChannelFuture[this.listenCount];
        for (int i = 0; i < this.listenCount; ++i) {
            ChannelFuture future = this.bootstrap.bind((SocketAddress)address);
            this.modifyHandlers(future);
            this.bootstrapFutures[i] = future;
        }
        return Bootstraps.allOf(this.bootstrapFutures);
    }

    private void modifyHandlers(ChannelFuture future) {
        boolean isWhitelistedProxyProtocol;
        Channel channel = future.channel();
        channel.pipeline().addFirst("rak-connection-request-handler", (ChannelHandler)new RakConnectionRequestHandler(this)).addAfter("rak-offline-handler", "rak-ping-handler", (ChannelHandler)new RakPingHandler(this));
        boolean isProxyProtocol = this.geyser.getConfig().getBedrock().isEnableProxyProtocol();
        if (isProxyProtocol) {
            channel.pipeline().addFirst("proxy-protocol-decoder", (ChannelHandler)new ProxyServerHandler());
        }
        boolean bl = isWhitelistedProxyProtocol = isProxyProtocol && !this.geyser.getConfig().getBedrock().getProxyProtocolWhitelistedIPs().isEmpty();
        if (Boolean.parseBoolean(System.getProperty("Geyser.RakRateLimitingDisabled", "false")) || isWhitelistedProxyProtocol) {
            channel.pipeline().remove("rak-server-rate-limiter");
        } else {
            channel.pipeline().replace("rak-server-rate-limiter", "rak-geyser-rate-limiter", (ChannelHandler)new RakGeyserRateLimiter(channel));
        }
    }

    public void shutdown() {
        try {
            Future futureChildGroup = this.childGroup.shutdownGracefully(100L, 500L, TimeUnit.MILLISECONDS);
            this.childGroup = null;
            Future futureGroup = this.group.shutdownGracefully(100L, 500L, TimeUnit.MILLISECONDS);
            this.group = null;
            Future futurePlayerGroup = this.playerGroup.shutdownGracefully(100L, 500L, TimeUnit.MILLISECONDS);
            this.playerGroup = null;
            futureChildGroup.sync();
            futureGroup.sync();
            futurePlayerGroup.sync();
            SkinProvider.shutdown();
        }
        catch (InterruptedException e) {
            GeyserImpl.getInstance().getLogger().severe("Exception in shutdown process", e);
        }
        for (ChannelFuture f : this.bootstrapFutures) {
            f.channel().closeFuture().syncUninterruptibly();
        }
    }

    private ServerBootstrap createBootstrap() {
        if (this.geyser.getConfig().isDebugMode()) {
            this.geyser.getLogger().debug("EventLoop type: " + String.valueOf(TRANSPORT.datagramChannel()));
            if (TRANSPORT.datagramChannel() == NioDatagramChannel.class) {
                if (System.getProperties().contains("disableNativeEventLoop")) {
                    this.geyser.getLogger().debug("EventLoop type is NIO because native event loops are disabled.");
                } else {
                    this.geyser.getLogger().debug("Reason for no Epoll: " + String.valueOf(GeyserServer.throwableOrCaught(() -> Epoll.unavailabilityCause())));
                    this.geyser.getLogger().debug("Reason for no KQueue: " + String.valueOf(GeyserServer.throwableOrCaught(() -> KQueue.unavailabilityCause())));
                }
            }
        }
        GeyserServerInitializer serverInitializer = new GeyserServerInitializer(this.geyser);
        this.playerGroup = serverInitializer.getEventLoopGroup();
        this.geyser.getLogger().debug("Setting MTU to " + this.geyser.getConfig().getMtu());
        int rakPacketLimit = GeyserServer.positivePropOrDefault("Geyser.RakPacketLimit", 120);
        this.geyser.getLogger().debug("Setting RakNet packet limit to " + rakPacketLimit);
        int rakGlobalPacketLimit = GeyserServer.positivePropOrDefault("Geyser.RakGlobalPacketLimit", 100000);
        this.geyser.getLogger().debug("Setting RakNet global packet limit to " + rakGlobalPacketLimit);
        boolean rakSendCookie = Boolean.parseBoolean(System.getProperty("Geyser.RakSendCookie", "true"));
        this.geyser.getLogger().debug("Setting RakNet send cookie to " + rakSendCookie);
        return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channelFactory(RakChannelFactory.server(TRANSPORT.datagramChannel()))).group(this.group, this.childGroup).option(RakChannelOption.RAK_HANDLE_PING, (Object)true)).option(RakChannelOption.RAK_MAX_MTU, (Object)this.geyser.getConfig().getMtu())).option(RakChannelOption.RAK_PACKET_LIMIT, (Object)rakPacketLimit)).option(RakChannelOption.RAK_GLOBAL_PACKET_LIMIT, (Object)rakGlobalPacketLimit)).option(RakChannelOption.RAK_SEND_COOKIE, (Object)rakSendCookie)).childHandler((ChannelHandler)serverInitializer);
    }

    public boolean onConnectionRequest(InetSocketAddress inetSocketAddress) {
        List<String> allowedProxyIPs = this.geyser.getConfig().getBedrock().getProxyProtocolWhitelistedIPs();
        if (this.geyser.getConfig().getBedrock().isEnableProxyProtocol() && !allowedProxyIPs.isEmpty()) {
            boolean isWhitelistedIP = false;
            for (CIDRMatcher matcher : this.geyser.getConfig().getBedrock().getWhitelistedIPsMatchers()) {
                if (!matcher.matches(inetSocketAddress.getAddress())) continue;
                isWhitelistedIP = true;
                break;
            }
            if (!isWhitelistedIP) {
                ++this.connectionAttempts;
                return false;
            }
        }
        String ip = this.geyser.getConfig().isLogPlayerIpAddresses() ? (this.geyser.getConfig().getBedrock().isEnableProxyProtocol() ? ((InetSocketAddress)this.proxiedAddresses.getOrDefault((Object)inetSocketAddress, (Object)inetSocketAddress)).toString() : inetSocketAddress.toString()) : "<IP address withheld>";
        ConnectionRequestEvent requestEvent = new ConnectionRequestEvent(inetSocketAddress, this.proxiedAddresses != null ? (InetSocketAddress)this.proxiedAddresses.get((Object)inetSocketAddress) : null);
        this.geyser.eventBus().fire(requestEvent);
        if (requestEvent.isCancelled()) {
            this.geyser.getLogger().debug("Connection request from " + ip + " was cancelled using the API!");
            ++this.connectionAttempts;
            return false;
        }
        this.geyser.getLogger().debug(GeyserLocale.getLocaleStringLog("geyser.network.attempt_connect", ip));
        ++this.connectionAttempts;
        return true;
    }

    public BedrockPong onQuery(Channel channel, InetSocketAddress inetSocketAddress) {
        int subMotdLength;
        byte[] motdArray;
        IGeyserPingPassthrough pingPassthrough;
        if (this.geyser.getConfig().isDebugMode() && PRINT_DEBUG_PINGS) {
            String ip = this.geyser.getConfig().isLogPlayerIpAddresses() ? (this.geyser.getConfig().getBedrock().isEnableProxyProtocol() ? ((InetSocketAddress)this.proxiedAddresses.getOrDefault((Object)inetSocketAddress, (Object)inetSocketAddress)).toString() : inetSocketAddress.toString()) : "<IP address withheld>";
            this.geyser.getLogger().debug(GeyserLocale.getLocaleStringLog("geyser.network.pinged", ip));
        }
        GeyserConfiguration config = this.geyser.getConfig();
        GeyserPingInfo pingInfo = null;
        if ((config.isPassthroughMotd() || config.isPassthroughPlayerCounts()) && (pingPassthrough = this.geyser.getBootstrap().getGeyserPingPassthrough()) != null) {
            pingInfo = pingPassthrough.getPingInformation(inetSocketAddress);
        }
        BedrockPong pong = new BedrockPong().edition("MCPE").gameType("Survival").nintendoLimited(false).protocolVersion(GameProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()).version(PING_VERSION).ipv4Port(this.broadcastPort).ipv6Port(this.broadcastPort).serverId((Long)channel.config().getOption(RakChannelOption.RAK_GUID));
        if (config.isPassthroughMotd() && pingInfo != null && pingInfo.getDescription() != null) {
            String[] motd = MessageTranslator.convertMessageLenient(pingInfo.getDescription()).split("\n");
            String mainMotd = motd.length > 0 ? motd[0] : config.getBedrock().primaryMotd();
            String subMotd = motd.length > 1 ? motd[1] : config.getBedrock().secondaryMotd();
            pong.motd(mainMotd.trim());
            pong.subMotd(subMotd.trim());
        } else {
            pong.motd(config.getBedrock().primaryMotd());
            pong.subMotd(config.getBedrock().secondaryMotd());
        }
        if (config.isPassthroughPlayerCounts() && pingInfo != null) {
            pong.playerCount(pingInfo.getPlayers().getOnline());
            pong.maximumPlayerCount(pingInfo.getPlayers().getMax());
        } else {
            pong.playerCount(this.geyser.getSessionManager().getSessions().size());
            pong.maximumPlayerCount(config.getMaxPlayers());
        }
        this.geyser.eventBus().fire(new GeyserBedrockPingEventImpl(pong, inetSocketAddress));
        pong.motd(pong.motd().replace(';', ':'));
        pong.subMotd(pong.subMotd().replace(';', ':'));
        if (pong.motd() == null || pong.motd().isBlank()) {
            pong.motd("Geyser");
        }
        if (pong.subMotd() == null || pong.subMotd().isBlank()) {
            pong.subMotd("Geyser");
        }
        if (ConnectionTestCommand.CONNECTION_TEST_MOTD != null) {
            pong.motd(ConnectionTestCommand.CONNECTION_TEST_MOTD);
            pong.subMotd("Geyser");
        }
        if ((motdArray = pong.motd().getBytes(StandardCharsets.UTF_8)).length + (subMotdLength = pong.subMotd().getBytes(StandardCharsets.UTF_8).length) > 338 - PING_VERSION_BYTES_LENGTH) {
            if (subMotdLength > BRAND_BYTES_LENGTH) {
                pong.subMotd("Geyser");
                subMotdLength = BRAND_BYTES_LENGTH;
            }
            if (motdArray.length > 338 - PING_VERSION_BYTES_LENGTH - subMotdLength) {
                byte[] newMotdArray = new byte[338 - PING_VERSION_BYTES_LENGTH - subMotdLength];
                System.arraycopy(motdArray, 0, newMotdArray, 0, newMotdArray.length);
                pong.motd(new String(newMotdArray, StandardCharsets.UTF_8));
            }
        }
        if (pong.playerCount() >= pong.maximumPlayerCount()) {
            pong.maximumPlayerCount(pong.playerCount() + 1);
        }
        return pong;
    }

    private static String pingVersion() {
        String version = GameProtocol.DEFAULT_BEDROCK_CODEC.getMinecraftVersion();
        String[] versionSplit = version.split("/");
        if (versionSplit.length > 1) {
            version = versionSplit[versionSplit.length - 1];
        }
        return version;
    }

    private static Throwable throwableOrCaught(Supplier<Throwable> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable throwable) {
            return throwable;
        }
    }

    private static int positivePropOrDefault(String property, int defaultValue) {
        String value = System.getProperty(property);
        try {
            int parsed;
            int n = parsed = value != null ? Integer.parseInt(value) : defaultValue;
            if (parsed < 1) {
                GeyserImpl.getInstance().getLogger().warning("Non-postive integer value for " + property + ": " + value + ". Using default value: " + defaultValue);
                return defaultValue;
            }
            return parsed;
        }
        catch (NumberFormatException e) {
            GeyserImpl.getInstance().getLogger().warning("Invalid integer value for " + property + ": " + value + ". Using default value: " + defaultValue);
            return defaultValue;
        }
    }

    private static Transport compatibleTransport() {
        if (GeyserServer.isClassAvailable("io.netty.channel.epoll.Epoll") && Epoll.isAvailable()) {
            return new Transport(EpollDatagramChannel.class, EpollEventLoopGroup::new);
        }
        if (GeyserServer.isClassAvailable("io.netty.channel.kqueue.KQueue") && KQueue.isAvailable()) {
            return new Transport(KQueueDatagramChannel.class, KQueueEventLoopGroup::new);
        }
        return new Transport(NioDatagramChannel.class, NioEventLoopGroup::new);
    }

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public ExpiringMap<InetSocketAddress, InetSocketAddress> getProxiedAddresses() {
        return this.proxiedAddresses;
    }

    public int getConnectionAttempts() {
        return this.connectionAttempts;
    }

    private record Transport(Class<? extends DatagramChannel> datagramChannel, IntFunction<EventLoopGroup> eventLoopGroupFactory) {
    }
}

