/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.matrix;

import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.imaginary.Complexf;
import org.cloudburstmc.math.imaginary.Quaternionf;
import org.cloudburstmc.math.matrix.Matrix2f;
import org.cloudburstmc.math.matrix.Matrix3f;
import org.cloudburstmc.math.matrix.Matrix4f;
import org.cloudburstmc.math.matrix.MatrixNd;
import org.cloudburstmc.math.matrix.Matrixf;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.VectorNf;

@ParametersAreNonnullByDefault
public class MatrixNf
implements Matrixf,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final MatrixNf IDENTITY_2 = new ImmutableIdentityMatrixN(2);
    public static final MatrixNf IDENTITY_3 = new ImmutableIdentityMatrixN(3);
    public static final MatrixNf IDENTITY_4 = new ImmutableIdentityMatrixN(4);
    private final float[][] mat;

    private MatrixNf(float[][] mat) {
        this.mat = mat;
    }

    public int size() {
        return this.mat.length;
    }

    @Override
    public float get(int row, int col) {
        return this.mat[row][col];
    }

    @Override
    @Nonnull
    public VectorNf getRow(int row) {
        int size = this.size();
        VectorNf d = VectorNf.from(size);
        for (int col = 0; col < size; ++col) {
            d.set(col, this.get(row, col));
        }
        return d;
    }

    @Override
    @Nonnull
    public VectorNf getColumn(int col) {
        int size = this.size();
        VectorNf d = VectorNf.from(size);
        for (int row = 0; row < size; ++row) {
            d.set(row, this.get(row, col));
        }
        return d;
    }

    public void set(int row, int col, double val) {
        this.set(row, col, (float)val);
    }

    public void set(int row, int col, float val) {
        this.mat[row][col] = val;
    }

    public final void setIdentity() {
        int size = this.size();
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                this.mat[row][col] = row == col ? 1.0f : 0.0f;
            }
        }
    }

    public void setZero() {
        int size = this.size();
        for (int row = 0; row < size; ++row) {
            Arrays.fill(this.mat[row], 0.0f);
        }
    }

    @Nonnull
    public MatrixNf resize(int size) {
        MatrixNf d = MatrixNf.from(size);
        for (int rowCol = this.size(); rowCol < size; ++rowCol) {
            d.set(rowCol, rowCol, 0.0f);
        }
        size = Math.min(size, this.size());
        for (int row = 0; row < size; ++row) {
            System.arraycopy(this.mat[row], 0, d.mat[row], 0, size);
        }
        return d;
    }

    @Nonnull
    public MatrixNf add(MatrixNf m4) {
        int size = this.size();
        if (size != m4.size()) {
            throw new IllegalArgumentException("Matrix sizes must be the same");
        }
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                d.mat[row][col] = this.mat[row][col] + m4.mat[row][col];
            }
        }
        return d;
    }

    @Nonnull
    public MatrixNf sub(MatrixNf m4) {
        int size = this.size();
        if (size != m4.size()) {
            throw new IllegalArgumentException("Matrix sizes must be the same");
        }
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                d.mat[row][col] = this.mat[row][col] - m4.mat[row][col];
            }
        }
        return d;
    }

    @Nonnull
    public MatrixNf mul(double a) {
        return this.mul((float)a);
    }

    @Override
    @Nonnull
    public MatrixNf mul(float a) {
        int size = this.size();
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                d.mat[row][col] = this.mat[row][col] * a;
            }
        }
        return d;
    }

    @Nonnull
    public MatrixNf mul(MatrixNf m4) {
        int size = this.size();
        if (size != m4.size()) {
            throw new IllegalArgumentException("Matrix sizes must be the same");
        }
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                float dot = 0.0f;
                for (int i = 0; i < size; ++i) {
                    dot += this.mat[row][i] * m4.mat[i][col];
                }
                d.mat[row][col] = dot;
            }
        }
        return d;
    }

    @Nonnull
    public MatrixNf div(double a) {
        return this.div((float)a);
    }

    @Override
    @Nonnull
    public MatrixNf div(float a) {
        int size = this.size();
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                d.mat[row][col] = this.mat[row][col] / a;
            }
        }
        return d;
    }

    @Nonnull
    public MatrixNf div(MatrixNf m4) {
        return this.mul(m4.invert());
    }

    @Nonnull
    public MatrixNf pow(double pow) {
        return this.pow((float)pow);
    }

    @Override
    @Nonnull
    public MatrixNf pow(float pow) {
        int size = this.size();
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                d.mat[row][col] = (float)Math.pow(this.mat[row][col], pow);
            }
        }
        return d;
    }

    @Nonnull
    public MatrixNf translate(VectorNf v) {
        return this.translate(v.toArray());
    }

    @Nonnull
    public MatrixNf translate(float ... v) {
        return MatrixNf.createTranslation(v).mul(this);
    }

    @Nonnull
    public MatrixNf scale(VectorNf v) {
        return this.scale(v.toArray());
    }

    @Nonnull
    public MatrixNf scale(float ... v) {
        return MatrixNf.createScaling(v).mul(this);
    }

    @Nonnull
    public MatrixNf rotate(Complexf rot) {
        return MatrixNf.createRotation(this.size(), rot).mul(this);
    }

    @Nonnull
    public MatrixNf rotate(Quaternionf rot) {
        return MatrixNf.createRotation(this.size(), rot).mul(this);
    }

    @Nonnull
    public VectorNf transform(VectorNf v) {
        return this.transform(v.toArray());
    }

    @Nonnull
    public VectorNf transform(float ... vec) {
        int size = this.size();
        if (size != vec.length) {
            throw new IllegalArgumentException("Matrix and vector sizes must be the same");
        }
        VectorNf d = VectorNf.from(size);
        for (int row = 0; row < size; ++row) {
            float dot = 0.0f;
            for (int col = 0; col < size; ++col) {
                dot += this.mat[row][col] * vec[col];
            }
            d.set(row, dot);
        }
        return d;
    }

    @Override
    @Nonnull
    public MatrixNf floor() {
        int size = this.size();
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                d.mat[row][col] = GenericMath.floor(this.mat[row][col]);
            }
        }
        return d;
    }

    @Override
    @Nonnull
    public MatrixNf ceil() {
        int size = this.size();
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                d.mat[row][col] = (float)Math.ceil(this.mat[row][col]);
            }
        }
        return d;
    }

    @Override
    @Nonnull
    public MatrixNf round() {
        int size = this.size();
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                d.mat[row][col] = Math.round(this.mat[row][col]);
            }
        }
        return d;
    }

    @Override
    @Nonnull
    public MatrixNf abs() {
        int size = this.size();
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                d.mat[row][col] = Math.abs(this.mat[row][col]);
            }
        }
        return d;
    }

    @Override
    @Nonnull
    public MatrixNf negate() {
        int size = this.size();
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                d.mat[row][col] = -this.mat[row][col];
            }
        }
        return d;
    }

    @Override
    @Nonnull
    public MatrixNf transpose() {
        int size = this.size();
        MatrixNf d = MatrixNf.from(size);
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                d.mat[row][col] = this.mat[col][row];
            }
        }
        return d;
    }

    @Override
    public float trace() {
        int size = this.size();
        float trace = 0.0f;
        for (int rowCol = 0; rowCol < size; ++rowCol) {
            trace += this.mat[rowCol][rowCol];
        }
        return trace;
    }

    @Override
    public float determinant() {
        float det;
        int i;
        int size = this.size();
        float[][] m4 = MatrixNf.deepClone(this.mat);
        for (i = 0; i < size - 1; ++i) {
            for (int col = i + 1; col < size; ++col) {
                det = m4[i][i] < GenericMath.FLT_EPSILON ? 0.0f : m4[i][col] / m4[i][i];
                for (int row = i; row < size; ++row) {
                    float[] fArray = m4[row];
                    int n = col;
                    fArray[n] = fArray[n] - det * m4[row][i];
                }
            }
        }
        det = 1.0f;
        for (i = 0; i < size; ++i) {
            det *= m4[i][i];
        }
        return det;
    }

    @Override
    @Nonnull
    public MatrixNf invert() {
        if (Math.abs(this.determinant()) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot inverse a matrix with a zero determinant");
        }
        int size = this.size();
        AugmentedMatrixN augMat = new AugmentedMatrixN(this);
        int augmentedSize = augMat.getAugmentedSize();
        for (int i = 0; i < size; ++i) {
            for (int row = 0; row < size; ++row) {
                if (i == row) continue;
                float ratio = augMat.get(row, i) / augMat.get(i, i);
                for (int col = 0; col < augmentedSize; ++col) {
                    augMat.set(row, col, augMat.get(row, col) - ratio * augMat.get(i, col));
                }
            }
        }
        for (int row = 0; row < size; ++row) {
            float div = augMat.get(row, row);
            for (int col = 0; col < augmentedSize; ++col) {
                augMat.set(row, col, augMat.get(row, col) / div);
            }
        }
        return augMat.getAugmentation();
    }

    @Nonnull
    public Matrix2f toMatrix2() {
        return Matrix2f.from(this);
    }

    @Nonnull
    public Matrix3f toMatrix3() {
        return Matrix3f.from(this);
    }

    @Nonnull
    public Matrix4f toMatrix4() {
        return Matrix4f.from(this);
    }

    @Nonnull
    public float[] toArray() {
        return this.toArray(false);
    }

    @Override
    @Nonnull
    public MatrixNf toFloat() {
        int size = this.size();
        float[] m4 = new float[size * size];
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                m4[col + row * size] = this.get(row, col);
            }
        }
        return MatrixNf.from(m4);
    }

    @Override
    @Nonnull
    public MatrixNd toDouble() {
        int size = this.size();
        double[] m4 = new double[size * size];
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                m4[col + row * size] = this.get(row, col);
            }
        }
        return MatrixNd.from(m4);
    }

    @Override
    @Nonnull
    public float[] toArray(boolean columnMajor) {
        int size = this.size();
        float[] array = new float[size * size];
        if (columnMajor) {
            for (int col = 0; col < size; ++col) {
                for (int row = 0; row < size; ++row) {
                    array[row + col * size] = this.mat[row][col];
                }
            }
        } else {
            for (int row = 0; row < size; ++row) {
                System.arraycopy(this.mat[row], 0, array, row * size, size);
            }
        }
        return array;
    }

    @Nonnull
    public String toString() {
        int size = this.size();
        StringBuilder builder = new StringBuilder();
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                builder.append(this.mat[row][col]);
                if (col >= size - 1) continue;
                builder.append(' ');
            }
            if (row >= size - 1) continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MatrixNf)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.mat, (Object[])((MatrixNf)obj).mat);
    }

    public int hashCode() {
        return 395 + Arrays.deepHashCode((Object[])this.mat);
    }

    @Nonnull
    public MatrixNf clone() {
        return MatrixNf.from(this);
    }

    @Nonnull
    public static MatrixNf createScaling(VectorNf v) {
        return MatrixNf.createScaling(v.toArray());
    }

    @Nonnull
    public static MatrixNf createScaling(float ... vec) {
        int size = vec.length;
        MatrixNf m4 = MatrixNf.from(size);
        for (int rowCol = 0; rowCol < size; ++rowCol) {
            m4.set(rowCol, rowCol, vec[rowCol]);
        }
        return m4;
    }

    @Nonnull
    public static MatrixNf createTranslation(VectorNf v) {
        return MatrixNf.createTranslation(v.toArray());
    }

    @Nonnull
    public static MatrixNf createTranslation(float ... vec) {
        int size = vec.length;
        MatrixNf m4 = MatrixNf.from(size + 1);
        for (int row = 0; row < size; ++row) {
            m4.set(row, size, vec[row]);
        }
        return m4;
    }

    @Nonnull
    public static MatrixNf createRotation(int size, Complexf rot) {
        if (size < 2) {
            throw new IllegalArgumentException("Minimum matrix size is 2");
        }
        MatrixNf m4 = MatrixNf.from(size);
        rot = rot.normalize();
        m4.set(0, 0, rot.getX());
        m4.set(0, 1, -rot.getY());
        m4.set(1, 0, rot.getY());
        m4.set(1, 1, rot.getX());
        return m4;
    }

    @Nonnull
    public static MatrixNf createRotation(int size, Quaternionf rot) {
        if (size < 3) {
            throw new IllegalArgumentException("Minimum matrix size is 3");
        }
        MatrixNf m4 = MatrixNf.from(size);
        rot = rot.normalize();
        m4.set(0, 0, 1.0f - 2.0f * rot.getY() * rot.getY() - 2.0f * rot.getZ() * rot.getZ());
        m4.set(0, 1, 2.0f * rot.getX() * rot.getY() - 2.0f * rot.getW() * rot.getZ());
        m4.set(0, 2, 2.0f * rot.getX() * rot.getZ() + 2.0f * rot.getW() * rot.getY());
        m4.set(1, 0, 2.0f * rot.getX() * rot.getY() + 2.0f * rot.getW() * rot.getZ());
        m4.set(1, 1, 1.0f - 2.0f * rot.getX() * rot.getX() - 2.0f * rot.getZ() * rot.getZ());
        m4.set(1, 2, 2.0f * rot.getY() * rot.getZ() - 2.0f * rot.getW() * rot.getX());
        m4.set(2, 0, 2.0f * rot.getX() * rot.getZ() - 2.0f * rot.getW() * rot.getY());
        m4.set(2, 1, 2.0f * rot.getY() * rot.getZ() + 2.0f * rot.getX() * rot.getW());
        m4.set(2, 2, 1.0f - 2.0f * rot.getX() * rot.getX() - 2.0f * rot.getY() * rot.getY());
        return m4;
    }

    @Nonnull
    public static MatrixNf createLookAt(int size, Vector3f eye, Vector3f at, Vector3f up) {
        if (size < 4) {
            throw new IllegalArgumentException("Minimum matrix size is 4");
        }
        Vector3f f = at.sub(eye).normalize();
        up = up.normalize();
        Vector3f s2 = f.cross(up).normalize();
        Vector3f u = s2.cross(f).normalize();
        MatrixNf mat = MatrixNf.from(size);
        mat.set(0, 0, s2.getX());
        mat.set(0, 1, s2.getY());
        mat.set(0, 2, s2.getZ());
        mat.set(1, 0, u.getX());
        mat.set(1, 1, u.getY());
        mat.set(1, 2, u.getZ());
        mat.set(2, 0, -f.getX());
        mat.set(2, 1, -f.getY());
        mat.set(2, 2, -f.getZ());
        return mat.translate(eye.mul(-1.0f).toVectorN());
    }

    @Nonnull
    public static MatrixNf createPerspective(int size, double fov, double aspect, double near, double far) {
        return MatrixNf.createPerspective(size, (float)fov, (float)aspect, (float)near, (float)far);
    }

    @Nonnull
    public static MatrixNf createPerspective(int size, float fov, float aspect, float near, float far) {
        if (size < 4) {
            throw new IllegalArgumentException("Minimum matrix size is 4");
        }
        MatrixNf perspective = MatrixNf.from(size);
        float scale = 1.0f / TrigMath.tan(fov * ((float)Math.PI / 360));
        perspective.set(0, 0, scale / aspect);
        perspective.set(1, 1, scale);
        perspective.set(2, 2, (far + near) / (near - far));
        perspective.set(2, 3, 2.0f * far * near / (near - far));
        perspective.set(3, 2, -1.0f);
        perspective.set(3, 3, 0.0f);
        return perspective;
    }

    @Nonnull
    public static MatrixNf createOrthographic(int size, double right, double left, double top, double bottom, double near, double far) {
        return MatrixNf.createOrthographic(size, (float)right, (float)left, (float)top, (float)bottom, (float)near, (float)far);
    }

    @Nonnull
    public static MatrixNf createOrthographic(int size, float right, float left, float top, float bottom, float near, float far) {
        if (size < 4) {
            throw new IllegalArgumentException("Minimum matrix size is 4");
        }
        MatrixNf orthographic = MatrixNf.from(size);
        orthographic.set(0, 0, 2.0f / (right - left));
        orthographic.set(1, 1, 2.0f / (top - bottom));
        orthographic.set(2, 2, -2.0f / (far - near));
        orthographic.set(0, 3, -(right + left) / (right - left));
        orthographic.set(1, 3, -(top + bottom) / (top - bottom));
        orthographic.set(2, 3, -(far + near) / (far - near));
        return orthographic;
    }

    @Nonnull
    private static float[][] deepClone(float[][] array) {
        int size = array.length;
        float[][] clone = (float[][])array.clone();
        for (int i = 0; i < size; ++i) {
            clone[i] = (float[])array[i].clone();
        }
        return clone;
    }

    @Nonnull
    public static MatrixNf from(int size) {
        if (size < 2) {
            throw new IllegalArgumentException("Minimum matrix size is 2");
        }
        MatrixNf mat = new MatrixNf(new float[size][size]);
        mat.setIdentity();
        return mat;
    }

    @Nonnull
    public static MatrixNf from(Matrix2f m4) {
        return new MatrixNf(new float[][]{{m4.get(0, 0), m4.get(0, 1)}, {m4.get(1, 0), m4.get(1, 1)}});
    }

    @Nonnull
    public static MatrixNf from(Matrix3f m4) {
        return new MatrixNf(new float[][]{{m4.get(0, 0), m4.get(0, 1), m4.get(0, 2)}, {m4.get(1, 0), m4.get(1, 1), m4.get(1, 2)}, {m4.get(2, 0), m4.get(2, 1), m4.get(2, 2)}});
    }

    @Nonnull
    public static MatrixNf from(Matrix4f m4) {
        return new MatrixNf(new float[][]{{m4.get(0, 0), m4.get(0, 1), m4.get(0, 2), m4.get(0, 3)}, {m4.get(1, 0), m4.get(1, 1), m4.get(1, 2), m4.get(1, 3)}, {m4.get(2, 0), m4.get(2, 1), m4.get(2, 2), m4.get(2, 3)}, {m4.get(3, 0), m4.get(3, 1), m4.get(3, 2), m4.get(3, 3)}});
    }

    @Nonnull
    public static MatrixNf from(float ... m4) {
        if (m4.length < 4) {
            throw new IllegalArgumentException("Minimum matrix size is 2");
        }
        int size = (int)Math.ceil(Math.sqrt(m4.length));
        float[][] mat = new float[size][size];
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                int index = col + row * size;
                mat[row][col] = index < m4.length ? m4[index] : 0.0f;
            }
        }
        return new MatrixNf(mat);
    }

    @Nonnull
    public static MatrixNf from(MatrixNf m4) {
        return new MatrixNf(MatrixNf.deepClone(m4.mat));
    }

    private static class AugmentedMatrixN {
        private final MatrixNf mat;
        private final MatrixNf aug;
        private final int size;

        private AugmentedMatrixN(@Nonnull MatrixNf mat) {
            this.mat = mat.clone();
            this.size = mat.size();
            this.aug = MatrixNf.from(this.size);
        }

        @Nonnull
        private MatrixNf getAugmentation() {
            return this.aug;
        }

        private int getAugmentedSize() {
            return this.size * 2;
        }

        private float get(int row, int col) {
            if (col < this.size) {
                return this.mat.get(row, col);
            }
            return this.aug.get(row, col - this.size);
        }

        private void set(int row, int col, float val) {
            if (col < this.size) {
                this.mat.set(row, col, val);
            } else {
                this.aug.set(row, col - this.size, val);
            }
        }
    }

    private static class ImmutableIdentityMatrixN
    extends MatrixNf {
        public ImmutableIdentityMatrixN(int size) {
            super(new float[size][size]);
            this.setIdentity();
        }

        @Override
        public void set(int row, int col, float val) {
            throw new UnsupportedOperationException("You may not alter this matrix");
        }

        @Override
        public void setZero() {
            throw new UnsupportedOperationException("You may not alter this matrix");
        }
    }
}

