/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.vehicle;

import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.erosion.util.BlockPositionIterator;
import org.geysermc.geyser.entity.type.living.animal.HappyGhastEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.Fluid;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;

public class HappyGhastVehicleComponent
extends VehicleComponent<HappyGhastEntity> {
    private float flyingSpeed = 0.05f;
    private float cameraDistance;

    public HappyGhastVehicleComponent(HappyGhastEntity vehicle, float stepHeight) {
        super(vehicle, stepHeight);
        this.moveSpeed = 0.05f;
        this.cameraDistance = 8.0f;
    }

    @Override
    protected void updateRotation() {
        float yaw = ((HappyGhastEntity)this.vehicle).getYaw() + MathUtils.wrapDegrees(this.getRiddenRotation().getX() - ((HappyGhastEntity)this.vehicle).getYaw()) * 0.08f;
        ((HappyGhastEntity)this.vehicle).setYaw(yaw);
        ((HappyGhastEntity)this.vehicle).setHeadYaw(yaw);
    }

    @Override
    public void onMount() {
        super.onMount();
        SessionPlayerEntity playerEntity = ((HappyGhastEntity)this.vehicle).getSession().getPlayerEntity();
        playerEntity.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION, false);
        playerEntity.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION_DEGREES, Float.valueOf(181.0f));
        playerEntity.getDirtyMetadata().put(EntityDataTypes.SEAT_THIRD_PERSON_CAMERA_RADIUS, Float.valueOf(this.cameraDistance));
        playerEntity.getDirtyMetadata().put(EntityDataTypes.SEAT_CAMERA_RELAX_DISTANCE_SMOOTHING, Float.valueOf(this.cameraDistance * 0.75f));
        playerEntity.getDirtyMetadata().put(EntityDataTypes.CONTROLLING_RIDER_SEAT_INDEX, (byte)0);
    }

    @Override
    public void onDismount() {
        super.onDismount();
        SessionPlayerEntity playerEntity = ((HappyGhastEntity)this.vehicle).getSession().getPlayerEntity();
        playerEntity.getDirtyMetadata().put(EntityDataTypes.SEAT_THIRD_PERSON_CAMERA_RADIUS, Float.valueOf((float)AttributeType.Builtin.CAMERA_DISTANCE.getDef()));
        playerEntity.getDirtyMetadata().put(EntityDataTypes.SEAT_CAMERA_RELAX_DISTANCE_SMOOTHING, Float.valueOf(this.cameraDistance * 0.75f));
        playerEntity.getDirtyMetadata().put(EntityDataTypes.CONTROLLING_RIDER_SEAT_INDEX, (byte)0);
    }

    @Override
    public void tickVehicle() {
        if (!((HappyGhastEntity)this.vehicle).isClientControlled()) {
            return;
        }
        VehicleComponent.VehicleContext ctx = new VehicleComponent.VehicleContext(this);
        ctx.loadSurroundingBlocks();
        Fluid fluid = this.checkForFluid(ctx);
        float drag = switch (fluid) {
            default -> throw new IncompatibleClassChangeError();
            case Fluid.WATER -> 0.8f;
            case Fluid.LAVA -> 0.5f;
            case Fluid.EMPTY -> 0.91f;
        };
        this.travel(ctx, this.flyingSpeed * 5.0f / 3.0f);
        ((HappyGhastEntity)this.vehicle).setMotion(((HappyGhastEntity)this.vehicle).getMotion().mul(drag));
    }

    private Fluid checkForFluid(VehicleComponent.VehicleContext ctx) {
        Fluid result = Fluid.EMPTY;
        BoundingBox box = this.boundingBox.clone();
        box.expand(-0.001);
        Vector3d min2 = box.getMin();
        Vector3d max = box.getMax();
        BlockPositionIterator iter = BlockPositionIterator.fromMinMax(min2.getFloorX(), min2.getFloorY(), min2.getFloorZ(), max.getFloorX(), max.getFloorY(), max.getFloorZ());
        iter.reset();
        while (iter.hasNext()) {
            BlockState blockState = ctx.getBlock(iter);
            if (blockState.is(Blocks.WATER)) {
                return Fluid.WATER;
            }
            if (blockState.is(Blocks.LAVA)) {
                result = Fluid.LAVA;
            }
            iter.next();
        }
        return result;
    }

    public void setFlyingSpeed(float flyingSpeed) {
        this.flyingSpeed = flyingSpeed;
    }

    public void setCameraDistance(float cameraDistance) {
        this.cameraDistance = cameraDistance;
    }

    public float getFlyingSpeed() {
        return this.flyingSpeed;
    }

    public float getCameraDistance() {
        return this.cameraDistance;
    }
}

