/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.vector;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector3f;

@ParametersAreNonnullByDefault
@Immutable
public class ImmutableVector3f
extends Vector3f {
    private static final long serialVersionUID = 1L;
    private final float x;
    private final float y;
    private final float z;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableVector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    @Nonnull
    public Vector3f add(float x, float y, float z) {
        return Vector3f.from(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    @Override
    @Nonnull
    public Vector3f sub(float x, float y, float z) {
        return Vector3f.from(this.getX() - x, this.getY() - y, this.getZ() - z);
    }

    @Override
    @Nonnull
    public Vector3f mul(float x, float y, float z) {
        return Vector3f.from(this.getX() * x, this.getY() * y, this.getZ() * z);
    }

    @Override
    @Nonnull
    public Vector3f div(float x, float y, float z) {
        return Vector3f.from(this.getX() / x, this.getY() / y, this.getZ() / z);
    }

    @Override
    @Nonnull
    public Vector3f project(float x, float y, float z) {
        float lengthSquared = x * x + y * y + z * z;
        if (Math.abs(lengthSquared) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot project onto the zero vector");
        }
        float a = this.dot(x, y, z) / lengthSquared;
        return Vector3f.from(a * x, a * y, a * z);
    }

    @Override
    @Nonnull
    public Vector3f cross(float x, float y, float z) {
        return Vector3f.from(this.getY() * z - this.getZ() * y, this.getZ() * x - this.getX() * z, this.getX() * y - this.getY() * x);
    }

    @Override
    @Nonnull
    public Vector3f pow(float power) {
        return Vector3f.from(Math.pow(this.x, power), Math.pow(this.y, power), Math.pow(this.z, power));
    }

    @Override
    @Nonnull
    public Vector3f ceil() {
        return Vector3f.from(Math.ceil(this.getX()), Math.ceil(this.getY()), Math.ceil(this.getZ()));
    }

    @Override
    @Nonnull
    public Vector3f floor() {
        return Vector3f.from(GenericMath.floor(this.getX()), GenericMath.floor(this.getY()), GenericMath.floor(this.getZ()));
    }

    @Override
    @Nonnull
    public Vector3f round() {
        return Vector3f.from(Math.round(this.getX()), Math.round(this.getY()), Math.round(this.getZ()));
    }

    @Override
    @Nonnull
    public Vector3f abs() {
        return Vector3f.from(Math.abs(this.getX()), Math.abs(this.getY()), Math.abs(this.getZ()));
    }

    @Override
    @Nonnull
    public Vector3f negate() {
        return Vector3f.from(-this.getX(), -this.getY(), -this.getZ());
    }

    @Override
    @Nonnull
    public Vector3f min(float x, float y, float z) {
        return Vector3f.from(Math.min(this.getX(), x), Math.min(this.getY(), y), Math.min(this.getZ(), z));
    }

    @Override
    @Nonnull
    public Vector3f max(float x, float y, float z) {
        return Vector3f.from(Math.max(this.getX(), x), Math.max(this.getY(), y), Math.max(this.getZ(), z));
    }

    @Override
    @Nonnull
    public Vector3f up(float v) {
        return Vector3f.from(this.getX(), this.getY() + v, this.getZ());
    }

    @Override
    @Nonnull
    public Vector3f down(float v) {
        return Vector3f.from(this.getX(), this.getY() - v, this.getZ());
    }

    @Override
    @Nonnull
    public Vector3f north(float v) {
        return Vector3f.from(this.getX(), this.getY(), this.getZ() - v);
    }

    @Override
    @Nonnull
    public Vector3f south(float v) {
        return Vector3f.from(this.getX(), this.getY(), this.getZ() + v);
    }

    @Override
    @Nonnull
    public Vector3f east(float v) {
        return Vector3f.from(this.getX() + v, this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3f west(float v) {
        return Vector3f.from(this.getX() - v, this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3f normalize() {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero vector");
        }
        return Vector3f.from(this.getX() / length, this.getY() / length, this.getZ() / length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector3f)) {
            return false;
        }
        Vector3f vector3 = (Vector3f)o;
        if (Float.compare(vector3.getX(), this.x) != 0) {
            return false;
        }
        if (Float.compare(vector3.getY(), this.y) != 0) {
            return false;
        }
        return Float.compare(vector3.getZ(), this.z) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0f ? Float.hashCode(this.x) : 0;
            result = 31 * result + (this.y != 0.0f ? Float.hashCode(this.y) : 0);
            this.hashCode = 31 * result + (this.z != 0.0f ? Float.hashCode(this.z) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

