/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.horse.CamelEntity;
import org.geysermc.geyser.entity.type.living.animal.horse.ChestedHorseEntity;
import org.geysermc.geyser.entity.type.living.animal.horse.LlamaEntity;
import org.geysermc.geyser.entity.type.living.animal.horse.SkeletonHorseEntity;
import org.geysermc.geyser.entity.type.living.animal.horse.ZombieHorseEntity;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.InventoryHolder;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.UpdateEquipPacket;
import org.geysermc.geyser.translator.inventory.horse.AbstractHorseInventoryTranslator;
import org.geysermc.geyser.translator.inventory.horse.DonkeyInventoryTranslator;
import org.geysermc.geyser.translator.inventory.horse.HorseInventoryTranslator;
import org.geysermc.geyser.translator.inventory.horse.LlamaInventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory.ClientboundHorseScreenOpenPacket;

@Translator(packet=ClientboundHorseScreenOpenPacket.class)
public class JavaHorseScreenOpenTranslator
extends PacketTranslator<ClientboundHorseScreenOpenPacket> {
    private static final NbtMap ARMOR_SLOT;
    private static final NbtMap CARPET_SLOT;
    private static final NbtMap SADDLE_SLOT;

    @Override
    public void translate(GeyserSession session, ClientboundHorseScreenOpenPacket packet) {
        AbstractHorseInventoryTranslator inventoryTranslator;
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        UpdateEquipPacket updateEquipPacket = new UpdateEquipPacket();
        updateEquipPacket.setWindowId((short)packet.getContainerId());
        updateEquipPacket.setWindowType((short)ContainerType.HORSE.getId());
        updateEquipPacket.setUniqueEntityId(entity.getGeyserId());
        NbtMapBuilder builder = NbtMap.builder();
        ArrayList<NbtMap> slots = new ArrayList<NbtMap>();
        int slotCount = 2;
        if (entity instanceof LlamaEntity) {
            LlamaEntity llamaEntity = (LlamaEntity)entity;
            if (entity.getFlag(EntityFlag.CHESTED)) {
                slotCount += llamaEntity.getStrength() * 3;
            }
            inventoryTranslator = new LlamaInventoryTranslator(slotCount);
            slots.add(CARPET_SLOT);
        } else if (entity instanceof ChestedHorseEntity) {
            if (entity.getFlag(EntityFlag.CHESTED)) {
                slotCount += 15;
            }
            inventoryTranslator = new DonkeyInventoryTranslator(slotCount);
            slots.add(SADDLE_SLOT);
        } else if (entity instanceof CamelEntity) {
            if (entity.getFlag(EntityFlag.CHESTED)) {
                slotCount += 15;
            }
            inventoryTranslator = new DonkeyInventoryTranslator(slotCount);
            slots.add(SADDLE_SLOT);
        } else {
            inventoryTranslator = new HorseInventoryTranslator(slotCount);
            slots.add(SADDLE_SLOT);
            if (!(entity instanceof SkeletonHorseEntity) && !(entity instanceof ZombieHorseEntity)) {
                slots.add(ARMOR_SLOT);
            }
        }
        builder.putList("slots", NbtType.COMPOUND, slots);
        updateEquipPacket.setTag(builder.build());
        session.sendUpstreamPacket(updateEquipPacket);
        Container container = new Container(session, entity.getNametag(), packet.getContainerId(), slotCount, null);
        InventoryUtils.openInventory(new InventoryHolder(session, container, inventoryTranslator));
    }

    static {
        String[] acceptedHorseArmorIdentifiers = new String[]{"minecraft:horsearmorleather", "minecraft:horsearmoriron", "minecraft:horsearmorgold", "minecraft:horsearmordiamond"};
        NbtMapBuilder armorBuilder = NbtMap.builder();
        ArrayList<NbtMap> acceptedArmors = new ArrayList<NbtMap>(4);
        for (String identifier : acceptedHorseArmorIdentifiers) {
            NbtMapBuilder acceptedItemBuilder = NbtMap.builder().putShort("Aux", (short)Short.MAX_VALUE).putString("Name", identifier);
            acceptedArmors.add(NbtMap.builder().putCompound("slotItem", acceptedItemBuilder.build()).build());
        }
        armorBuilder.putList("acceptedItems", NbtType.COMPOUND, acceptedArmors);
        NbtMapBuilder armorItem = NbtMap.builder().putShort("Aux", (short)Short.MAX_VALUE).putString("Name", "minecraft:horsearmoriron");
        armorBuilder.putCompound("item", armorItem.build());
        armorBuilder.putInt("slotNumber", 1);
        ARMOR_SLOT = armorBuilder.build();
        NbtMapBuilder carpetBuilder = NbtMap.builder();
        NbtMapBuilder carpetItem = NbtMap.builder().putShort("Aux", (short)Short.MAX_VALUE).putString("Name", "minecraft:carpet");
        List<NbtMap> acceptedCarpet = Collections.singletonList(NbtMap.builder().putCompound("slotItem", carpetItem.build()).build());
        carpetBuilder.putList("acceptedItems", NbtType.COMPOUND, acceptedCarpet);
        carpetBuilder.putCompound("item", carpetItem.build());
        carpetBuilder.putInt("slotNumber", 1);
        CARPET_SLOT = carpetBuilder.build();
        NbtMapBuilder saddleBuilder = NbtMap.builder();
        NbtMapBuilder acceptedSaddle = NbtMap.builder().putShort("Aux", (short)Short.MAX_VALUE).putString("Name", "minecraft:saddle");
        List<NbtMap> acceptedItem = Collections.singletonList(NbtMap.builder().putCompound("slotItem", acceptedSaddle.build()).build());
        saddleBuilder.putList("acceptedItems", NbtType.COMPOUND, acceptedItem);
        saddleBuilder.putCompound("item", acceptedSaddle.build());
        saddleBuilder.putInt("slotNumber", 0);
        SADDLE_SLOT = saddleBuilder.build();
    }
}

