/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.packet.backendbound;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.erosion.packet.backendbound.BackendboundPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundPacketHandler;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public final class BackendboundBatchBlockEntityPacket
implements BackendboundPacket {
    private final int x;
    private final int z;
    private final List<Vector3i> blockEntityInfos;

    public BackendboundBatchBlockEntityPacket(ByteBuf buf) {
        short y;
        boolean next;
        this.x = VarInts.readInt(buf);
        this.z = VarInts.readInt(buf);
        this.blockEntityInfos = new ObjectArrayList<Vector3i>();
        do {
            byte xz = buf.readByte();
            y = buf.readShort();
            this.blockEntityInfos.add(Vector3i.from(xz >> 4 & 0xF, y >> 1, xz & 0xF));
        } while (next = (y & 1) != 0);
    }

    public BackendboundBatchBlockEntityPacket(int x, int z, List<Vector3i> blockEntityInfos) {
        this.x = x;
        this.z = z;
        this.blockEntityInfos = blockEntityInfos;
    }

    @Override
    public void serialize(ByteBuf buf) {
        VarInts.writeInt(buf, this.x);
        VarInts.writeInt(buf, this.z);
        Iterator<Vector3i> it = this.blockEntityInfos.iterator();
        while (it.hasNext()) {
            Vector3i blockEntityInfo = it.next();
            buf.writeByte((blockEntityInfo.getX() & 0xF) << 4 | blockEntityInfo.getZ() & 0xF);
            buf.writeShort(blockEntityInfo.getY() << 1 | (it.hasNext() ? 1 : 0));
        }
    }

    @Override
    public void handle(BackendboundPacketHandler packetHandler) {
        packetHandler.handleBatchBlockEntity(this);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public List<Vector3i> getBlockEntityInfos() {
        return this.blockEntityInfos;
    }
}

