/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.furnace;

import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.packet.ContainerSetDataPacket;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.updater.ContainerInventoryUpdater;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;

public abstract class AbstractFurnaceInventoryTranslator
extends AbstractBlockInventoryTranslator {
    AbstractFurnaceInventoryTranslator(Block javaBlock, ContainerType containerType) {
        super(3, javaBlock.defaultBlockState().withValue(Properties.LIT, false), containerType, (InventoryUpdater)ContainerInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    public void updateProperty(GeyserSession session, Inventory inventory, int key, int value) {
        ContainerSetDataPacket dataPacket = new ContainerSetDataPacket();
        dataPacket.setWindowId((byte)inventory.getBedrockId());
        switch (key) {
            case 0: {
                dataPacket.setProperty(1);
                break;
            }
            case 1: {
                dataPacket.setProperty(2);
                break;
            }
            case 2: {
                dataPacket.setProperty(0);
                break;
            }
            default: {
                return;
            }
        }
        dataPacket.setValue(value);
        session.sendUpstreamPacket(dataPacket);
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        if (javaSlot == 2) {
            return SlotType.FURNACE_OUTPUT;
        }
        return SlotType.NORMAL;
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        if (slot == 1) {
            return new BedrockContainerSlot(ContainerSlotType.FURNACE_FUEL, this.javaSlotToBedrock(slot));
        }
        if (slot == 2) {
            return new BedrockContainerSlot(ContainerSlotType.FURNACE_RESULT, this.javaSlotToBedrock(slot));
        }
        return super.javaSlotToBedrockContainer(slot);
    }
}

