/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.stream.Stream;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.databind.JsonNode;

public class WebUtils {
    public static String getBody(String reqURL) {
        try {
            URL url = new URL(reqURL);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            return WebUtils.connectionToString(con);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static JsonNode getJson(String reqURL) throws IOException {
        HttpURLConnection con = (HttpURLConnection)new URL(reqURL).openConnection();
        con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
        con.setConnectTimeout(10000);
        con.setReadTimeout(10000);
        return GeyserImpl.JSON_MAPPER.readTree(con.getInputStream());
    }

    public static void downloadFile(String reqURL, String fileLocation) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(reqURL).openConnection();
            con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
            InputStream in = con.getInputStream();
            Files.copy(in, Paths.get(fileLocation, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to download and save file: " + fileLocation + " (" + reqURL + ")", e);
        }
    }

    public static String post(String reqURL, String postContent) throws IOException {
        URL url = new URL(reqURL);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "text/plain");
        con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
        con.setDoOutput(true);
        OutputStream out = con.getOutputStream();
        out.write(postContent.getBytes(StandardCharsets.UTF_8));
        out.close();
        return WebUtils.connectionToString(con);
    }

    private static String connectionToString(HttpURLConnection con) throws IOException {
        con.getResponseCode();
        InputStream inputStream = con.getErrorStream();
        if (inputStream == null) {
            inputStream = con.getInputStream();
        }
        StringBuilder content = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
                content.append("\n");
            }
            con.disconnect();
        }
        return content.toString();
    }

    public static String postForm(String reqURL, Map<String, String> fields) throws IOException {
        URL url = new URL(reqURL);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
        con.setDoOutput(true);
        try (OutputStream out = con.getOutputStream();){
            for (Map.Entry<String, String> field : fields.entrySet()) {
                out.write((field.getKey() + "=" + URLEncoder.encode(field.getValue(), StandardCharsets.UTF_8) + "&").getBytes(StandardCharsets.UTF_8));
            }
        }
        return WebUtils.connectionToString(con);
    }

    public static String @Nullable [] findSrvRecord(GeyserImpl geyser, String remoteAddress) {
        block3: {
            try {
                InitialDirContext ctx = new InitialDirContext();
                Attribute attr = ctx.getAttributes("dns:///_minecraft._tcp." + remoteAddress, new String[]{"SRV"}).get("SRV");
                if (attr != null && attr.size() > 0) {
                    return ((String)attr.get(0)).split(" ");
                }
            }
            catch (Exception | NoClassDefFoundError ex) {
                if (!geyser.getConfig().isDebugMode()) break block3;
                geyser.getLogger().debug("Exception while trying to find an SRV record for the remote host.");
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static Stream<String> getLineStream(String reqURL) {
        try {
            URL url = new URL(reqURL);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            return WebUtils.connectionToString(con).lines();
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Error while trying to get a stream from " + reqURL, e);
            return Stream.empty();
        }
    }

    public static String getUserAgent() {
        return "Geyser-" + GeyserImpl.getInstance().getPlatformType().platformName() + "/2.6.1-b774 (git-master-5f0611f)";
    }
}

