/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;

public record ArmorTrim(Holder<TrimMaterial> material, Holder<TrimPattern> pattern, boolean showInTooltip) {
    public static @NonNull ArmorTrimBuilder builder() {
        return new ArmorTrimBuilder();
    }

    public @NonNull ArmorTrimBuilder toBuilder() {
        return new ArmorTrimBuilder().material(this.material).pattern(this.pattern).showInTooltip(this.showInTooltip);
    }

    public static class ArmorTrimBuilder {
        private Holder<TrimMaterial> material;
        private Holder<TrimPattern> pattern;
        private boolean showInTooltip;

        ArmorTrimBuilder() {
        }

        public @NonNull ArmorTrimBuilder material(Holder<TrimMaterial> material) {
            this.material = material;
            return this;
        }

        public @NonNull ArmorTrimBuilder pattern(Holder<TrimPattern> pattern) {
            this.pattern = pattern;
            return this;
        }

        public @NonNull ArmorTrimBuilder showInTooltip(boolean showInTooltip) {
            this.showInTooltip = showInTooltip;
            return this;
        }

        public @NonNull ArmorTrim build() {
            return new ArmorTrim(this.material, this.pattern, this.showInTooltip);
        }

        public @NonNull String toString() {
            return "ArmorTrim.ArmorTrimBuilder(material=" + String.valueOf(this.material) + ", pattern=" + String.valueOf(this.pattern) + ", showInTooltip=" + this.showInTooltip + ")";
        }
    }

    public record TrimPattern(Key assetId, int templateItemId, Component description, boolean decal) {
        public static @NonNull TrimPatternBuilder builder() {
            return new TrimPatternBuilder();
        }

        public @NonNull TrimPatternBuilder toBuilder() {
            return new TrimPatternBuilder().assetId(this.assetId).templateItemId(this.templateItemId).description(this.description).decal(this.decal);
        }

        public static class TrimPatternBuilder {
            private Key assetId;
            private int templateItemId;
            private Component description;
            private boolean decal;

            TrimPatternBuilder() {
            }

            public @NonNull TrimPatternBuilder assetId(Key assetId) {
                this.assetId = assetId;
                return this;
            }

            public @NonNull TrimPatternBuilder templateItemId(int templateItemId) {
                this.templateItemId = templateItemId;
                return this;
            }

            public @NonNull TrimPatternBuilder description(Component description) {
                this.description = description;
                return this;
            }

            public @NonNull TrimPatternBuilder decal(boolean decal) {
                this.decal = decal;
                return this;
            }

            public @NonNull TrimPattern build() {
                return new TrimPattern(this.assetId, this.templateItemId, this.description, this.decal);
            }

            public @NonNull String toString() {
                return "ArmorTrim.TrimPattern.TrimPatternBuilder(assetId=" + String.valueOf(this.assetId) + ", templateItemId=" + this.templateItemId + ", description=" + String.valueOf(this.description) + ", decal=" + this.decal + ")";
            }
        }
    }

    public record TrimMaterial(String assetName, int ingredientId, Map<Key, String> overrideArmorAssets, Component description) {
        public TrimMaterial(String assetName, int ingredientId, Map<Key, String> overrideArmorAssets, Component description) {
            this.assetName = assetName;
            this.ingredientId = ingredientId;
            this.overrideArmorAssets = Map.copyOf(overrideArmorAssets);
            this.description = description;
        }

        public static @NonNull TrimMaterialBuilder builder() {
            return new TrimMaterialBuilder();
        }

        public @NonNull TrimMaterialBuilder toBuilder() {
            return new TrimMaterialBuilder().assetName(this.assetName).ingredientId(this.ingredientId).overrideArmorAssets(this.overrideArmorAssets).description(this.description);
        }

        public static class TrimMaterialBuilder {
            private String assetName;
            private int ingredientId;
            private Map<Key, String> overrideArmorAssets;
            private Component description;

            TrimMaterialBuilder() {
            }

            public @NonNull TrimMaterialBuilder assetName(String assetName) {
                this.assetName = assetName;
                return this;
            }

            public @NonNull TrimMaterialBuilder ingredientId(int ingredientId) {
                this.ingredientId = ingredientId;
                return this;
            }

            public @NonNull TrimMaterialBuilder overrideArmorAssets(Map<Key, String> overrideArmorAssets) {
                this.overrideArmorAssets = overrideArmorAssets;
                return this;
            }

            public @NonNull TrimMaterialBuilder description(Component description) {
                this.description = description;
                return this;
            }

            public @NonNull TrimMaterial build() {
                return new TrimMaterial(this.assetName, this.ingredientId, this.overrideArmorAssets, this.description);
            }

            public @NonNull String toString() {
                return "ArmorTrim.TrimMaterial.TrimMaterialBuilder(assetName=" + this.assetName + ", ingredientId=" + this.ingredientId + ", overrideArmorAssets=" + String.valueOf(this.overrideArmorAssets) + ", description=" + String.valueOf(this.description) + ")";
            }
        }
    }
}

