/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.api.item.custom;

import java.util.Set;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.item.custom.CustomRenderOffsets;

public interface NonVanillaCustomItemData
extends CustomItemData {
    public @NonNull String identifier();

    public @NonNegative int javaId();

    public @NonNegative int stackSize();

    public int maxDamage();

    public int attackDamage();

    public @Nullable String toolType();

    @Deprecated(forRemoval=true)
    public @Nullable String toolTier();

    public @Nullable String armorType();

    public int protectionValue();

    public @Nullable String translationString();

    @Deprecated(forRemoval=true)
    public @Nullable Set<String> repairMaterials();

    public boolean isHat();

    public boolean isFoil();

    public boolean isEdible();

    public boolean canAlwaysEat();

    public boolean isChargeable();

    @Deprecated
    default public boolean isTool() {
        return this.displayHandheld();
    }

    public String block();

    public static Builder builder() {
        return (Builder)GeyserApi.api().provider(Builder.class, new Object[0]);
    }

    public static interface Builder
    extends CustomItemData.Builder {
        @Override
        public Builder name(@NonNull String var1);

        public Builder identifier(@NonNull String var1);

        public Builder javaId(@NonNegative int var1);

        public Builder stackSize(@NonNegative int var1);

        public Builder maxDamage(int var1);

        public Builder attackDamage(int var1);

        public Builder toolType(@Nullable String var1);

        public Builder toolTier(@Nullable String var1);

        public Builder armorType(@Nullable String var1);

        public Builder protectionValue(int var1);

        public Builder translationString(@Nullable String var1);

        public Builder repairMaterials(@Nullable Set<String> var1);

        public Builder hat(boolean var1);

        public Builder foil(boolean var1);

        public Builder edible(boolean var1);

        public Builder canAlwaysEat(boolean var1);

        public Builder chargeable(boolean var1);

        public Builder block(String var1);

        @Deprecated
        default public Builder tool(boolean isTool) {
            return this.displayHandheld(isTool);
        }

        @Override
        public Builder creativeCategory(int var1);

        @Override
        public Builder creativeGroup(@Nullable String var1);

        @Override
        public Builder customItemOptions(@NonNull CustomItemOptions var1);

        @Override
        public Builder displayName(@NonNull String var1);

        @Override
        public Builder icon(@NonNull String var1);

        @Override
        public Builder allowOffhand(boolean var1);

        @Override
        public Builder displayHandheld(boolean var1);

        @Override
        public Builder textureSize(int var1);

        @Override
        public Builder renderOffsets(@Nullable CustomRenderOffsets var1);

        @Override
        public Builder tags(@Nullable Set<String> var1);

        @Override
        public NonVanillaCustomItemData build();
    }
}

