/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.impl.camera;

import java.util.List;
import org.geysermc.geyser.api.bedrock.camera.CameraPerspective;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.camera.CameraAudioListener;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.camera.CameraPreset;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.DefinitionRegistry;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.NamedDefinition;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.SimpleDefinitionRegistry;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.OptionalBoolean;

public class CameraDefinitions {
    public static final DefinitionRegistry<NamedDefinition> CAMERA_DEFINITIONS;
    public static final List<CameraPreset> CAMERA_PRESETS;

    public static NamedDefinition getById(int id) {
        return CAMERA_DEFINITIONS.getDefinition(id);
    }

    public static NamedDefinition getByFunctionality(boolean audio, boolean effects) {
        if (!audio && !effects) {
            return CameraDefinitions.getById(1);
        }
        if (audio) {
            if (effects) {
                return CameraDefinitions.getById(6);
            }
            return CameraDefinitions.getById(4);
        }
        return CameraDefinitions.getById(5);
    }

    static {
        CAMERA_PRESETS = List.of(CameraPreset.builder().identifier(CameraPerspective.FIRST_PERSON.id()).build(), CameraPreset.builder().identifier(CameraPerspective.FREE.id()).build(), CameraPreset.builder().identifier(CameraPerspective.THIRD_PERSON.id()).build(), CameraPreset.builder().identifier(CameraPerspective.THIRD_PERSON_FRONT.id()).build(), CameraPreset.builder().identifier("geyser:free_audio").parentPreset(CameraPerspective.FREE.id()).listener(CameraAudioListener.PLAYER).playEffect(OptionalBoolean.of(false)).build(), CameraPreset.builder().identifier("geyser:free_effects").parentPreset(CameraPerspective.FREE.id()).listener(CameraAudioListener.CAMERA).playEffect(OptionalBoolean.of(true)).build(), CameraPreset.builder().identifier("geyser:free_audio_effects").parentPreset(CameraPerspective.FREE.id()).listener(CameraAudioListener.PLAYER).playEffect(OptionalBoolean.of(true)).build());
        SimpleDefinitionRegistry.Builder<CameraDefinition> builder = SimpleDefinitionRegistry.builder();
        for (int i = 0; i < CAMERA_PRESETS.size(); ++i) {
            builder.add(CameraDefinition.of(CAMERA_PRESETS.get(i).getIdentifier(), i));
        }
        CAMERA_DEFINITIONS = builder.build();
    }

    public record CameraDefinition(String identifier, int runtimeId) implements NamedDefinition
    {
        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public int getRuntimeId() {
            return this.runtimeId;
        }

        public static CameraDefinition of(String identifier, int runtimeId) {
            return new CameraDefinition(identifier, runtimeId);
        }
    }
}

