/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.netty.channel.proxy;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.handler.codec.raknet.ProxyInboundRouter;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.handler.codec.raknet.ProxyOutboundRouter;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.util.RakUtils;

public abstract class ProxyChannel<T extends Channel>
implements Channel {
    protected final T channel;
    protected final ChannelPipeline pipeline;

    protected ProxyChannel(T parent) {
        Objects.requireNonNull(parent, "parent");
        this.channel = parent;
        this.pipeline = this.newChannelPipeline();
        parent.pipeline().addLast("rak-proxy-inbound-router", (ChannelHandler)new ProxyInboundRouter(this));
        this.pipeline.addLast("rak-proxy-outbound-router", (ChannelHandler)new ProxyOutboundRouter(this));
    }

    public void onCloseTriggered(ChannelPromise promise) {
        this.channel.close(this.correctPromise(promise));
    }

    public ChannelPromise correctPromise(ChannelPromise remotePromise) {
        ChannelPromise localPromise = this.channel.newPromise();
        localPromise.addListener(future -> {
            if (future.isSuccess()) {
                remotePromise.trySuccess();
            } else {
                remotePromise.tryFailure(future.cause());
            }
        });
        return localPromise;
    }

    protected DefaultChannelPipeline newChannelPipeline() {
        return RakUtils.newChannelPipeline(this);
    }

    protected final ChannelPipeline internalPipeline() {
        return this.channel.pipeline();
    }

    public ChannelId id() {
        return this.channel.id();
    }

    public EventLoop eventLoop() {
        return this.channel.eventLoop();
    }

    public Channel parent() {
        return this.channel;
    }

    public ChannelConfig config() {
        return this.channel.config();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public boolean isRegistered() {
        return this.channel.isRegistered();
    }

    public boolean isActive() {
        return this.channel.isActive();
    }

    public ChannelMetadata metadata() {
        return this.channel.metadata();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public ChannelFuture closeFuture() {
        return this.channel.closeFuture();
    }

    public boolean isWritable() {
        return this.channel.isWritable();
    }

    public long bytesBeforeUnwritable() {
        return this.channel.bytesBeforeUnwritable();
    }

    public long bytesBeforeWritable() {
        return this.channel.bytesBeforeWritable();
    }

    public Channel.Unsafe unsafe() {
        return this.channel.unsafe();
    }

    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        return this.pipeline.bind(localAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.pipeline.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.pipeline.connect(remoteAddress, localAddress);
    }

    public ChannelFuture disconnect() {
        return this.pipeline.disconnect();
    }

    public ChannelFuture close() {
        return this.pipeline.close();
    }

    public ChannelFuture deregister() {
        return this.pipeline.deregister();
    }

    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.pipeline.bind(localAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.pipeline.connect(remoteAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return this.pipeline.connect(remoteAddress, localAddress, promise);
    }

    public ChannelFuture disconnect(ChannelPromise promise) {
        return this.pipeline.disconnect(promise);
    }

    public ChannelFuture close(ChannelPromise promise) {
        return this.pipeline.close(promise);
    }

    public ChannelFuture deregister(ChannelPromise promise) {
        return this.pipeline.deregister(promise);
    }

    public Channel read() {
        this.pipeline.read();
        return this;
    }

    public ChannelFuture write(Object msg) {
        return this.pipeline.write(msg);
    }

    public ChannelFuture write(Object msg, ChannelPromise promise) {
        return this.pipeline.write(msg, promise);
    }

    public Channel flush() {
        this.pipeline.flush();
        return this;
    }

    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        return this.pipeline.writeAndFlush(msg, promise);
    }

    public ChannelFuture writeAndFlush(Object msg) {
        return this.pipeline.writeAndFlush(msg);
    }

    public ChannelPromise newPromise() {
        return this.pipeline.newPromise();
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return this.pipeline.newProgressivePromise();
    }

    public ChannelFuture newSucceededFuture() {
        return this.pipeline.newSucceededFuture();
    }

    public ChannelFuture newFailedFuture(Throwable cause) {
        return this.pipeline.newFailedFuture(cause);
    }

    public ChannelPromise voidPromise() {
        return this.pipeline.voidPromise();
    }

    public <U> Attribute<U> attr(AttributeKey<U> key) {
        return this.channel.attr(key);
    }

    public <U> boolean hasAttr(AttributeKey<U> key) {
        return this.channel.hasAttr(key);
    }

    public int compareTo(Channel o) {
        return this.channel.compareTo((Object)o);
    }
}

