/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v465;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.EntityDataTypeMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v448.BedrockCodecHelper_v448;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.skin.AnimationData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.skin.ImageData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.skin.PersonaPieceData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.skin.PersonaPieceTintData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.skin.SerializedSkin;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.TypeMap;

public class BedrockCodecHelper_v465
extends BedrockCodecHelper_v448 {
    public BedrockCodecHelper_v465(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes, TypeMap<ItemStackRequestActionType> stackRequestActionTypes, TypeMap<ContainerSlotType> containerSlotTypes) {
        super(entityData, gameRulesTypes, stackRequestActionTypes, containerSlotTypes);
    }

    @Override
    public SerializedSkin readSkin(ByteBuf buffer) {
        String skinId = this.readString(buffer);
        String playFabId = this.readString(buffer);
        String skinResourcePatch = this.readString(buffer);
        ImageData skinData = this.readImage(buffer, 262144);
        ObjectArrayList animations = new ObjectArrayList();
        this.readArray(buffer, animations, ByteBuf::readIntLE, (ByteBuf b, BedrockCodecHelper h) -> this.readAnimationData((ByteBuf)b));
        ImageData capeData = this.readImage(buffer, 8192);
        String geometryData = this.readStringMaxLen(buffer, this.encodingSettings.maxGeometryDataSize());
        String geometryDataEngineVersion = this.readString(buffer);
        String animationData = this.readString(buffer);
        String capeId = this.readString(buffer);
        String fullSkinId = this.readString(buffer);
        String armSize = this.readString(buffer);
        String skinColor = this.readString(buffer);
        ObjectArrayList personaPieces = new ObjectArrayList();
        this.readArray(buffer, personaPieces, ByteBuf::readIntLE, (ByteBuf buf, BedrockCodecHelper h) -> {
            String pieceId = this.readString((ByteBuf)buf);
            String pieceType = this.readString((ByteBuf)buf);
            String packId = this.readString((ByteBuf)buf);
            boolean isDefault = buf.readBoolean();
            String productId = this.readString((ByteBuf)buf);
            return new PersonaPieceData(pieceId, pieceType, packId, isDefault, productId);
        });
        ObjectArrayList tintColors = new ObjectArrayList();
        this.readArray(buffer, tintColors, ByteBuf::readIntLE, (ByteBuf buf, BedrockCodecHelper h) -> {
            String pieceType = this.readString((ByteBuf)buf);
            ObjectArrayList colors = new ObjectArrayList();
            int colorsLength = buf.readIntLE();
            for (int i2 = 0; i2 < colorsLength; ++i2) {
                colors.add(this.readString((ByteBuf)buf));
            }
            return new PersonaPieceTintData(pieceType, (List<String>)colors);
        });
        boolean premium = buffer.readBoolean();
        boolean persona = buffer.readBoolean();
        boolean capeOnClassic = buffer.readBoolean();
        boolean primaryUser = buffer.readBoolean();
        return SerializedSkin.of(skinId, playFabId, skinResourcePatch, skinData, (List<AnimationData>)animations, capeData, geometryData, geometryDataEngineVersion, animationData, premium, persona, capeOnClassic, primaryUser, capeId, fullSkinId, armSize, skinColor, (List<PersonaPieceData>)personaPieces, (List<PersonaPieceTintData>)tintColors);
    }

    @Override
    public void writeSkin(ByteBuf buffer, SerializedSkin skin) {
        Objects.requireNonNull(skin, "Skin is null");
        this.writeString(buffer, skin.getSkinId());
        this.writeString(buffer, skin.getPlayFabId());
        this.writeString(buffer, skin.getSkinResourcePatch());
        this.writeImage(buffer, skin.getSkinData());
        List<AnimationData> animations = skin.getAnimations();
        buffer.writeIntLE(animations.size());
        for (AnimationData animationData : animations) {
            this.writeAnimationData(buffer, animationData);
        }
        this.writeImage(buffer, skin.getCapeData());
        this.writeString(buffer, skin.getGeometryData());
        this.writeString(buffer, skin.getGeometryDataEngineVersion());
        this.writeString(buffer, skin.getAnimationData());
        this.writeString(buffer, skin.getCapeId());
        this.writeString(buffer, skin.getFullSkinId());
        this.writeString(buffer, skin.getArmSize());
        this.writeString(buffer, skin.getSkinColor());
        List<PersonaPieceData> pieces = skin.getPersonaPieces();
        buffer.writeIntLE(pieces.size());
        for (PersonaPieceData piece : pieces) {
            this.writeString(buffer, piece.getId());
            this.writeString(buffer, piece.getType());
            this.writeString(buffer, piece.getPackId());
            buffer.writeBoolean(piece.isDefault());
            this.writeString(buffer, piece.getProductId());
        }
        List<PersonaPieceTintData> list = skin.getTintColors();
        buffer.writeIntLE(list.size());
        for (PersonaPieceTintData tint : list) {
            this.writeString(buffer, tint.getType());
            List<String> colors = tint.getColors();
            buffer.writeIntLE(colors.size());
            for (String color : colors) {
                this.writeString(buffer, color);
            }
        }
        buffer.writeBoolean(skin.isPremium());
        buffer.writeBoolean(skin.isPersona());
        buffer.writeBoolean(skin.isCapeOnClassic());
        buffer.writeBoolean(skin.isPrimaryUser());
    }
}

