/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.level.LightUpdateData;

public class ClientboundLightUpdatePacket
implements MinecraftPacket {
    private final int x;
    private final int z;
    @lombok.NonNull
    private final LightUpdateData lightData;

    public ClientboundLightUpdatePacket(int x, int z, @lombok.NonNull BitSet skyYMask, @lombok.NonNull BitSet blockYMask, @lombok.NonNull BitSet emptySkyYMask, @lombok.NonNull BitSet emptyBlockYMask, @lombok.NonNull List<byte[]> skyUpdates, @lombok.NonNull List<byte[]> blockUpdates) {
        if (skyYMask == null) {
            throw new NullPointerException("skyYMask is marked non-null but is null");
        }
        if (blockYMask == null) {
            throw new NullPointerException("blockYMask is marked non-null but is null");
        }
        if (emptySkyYMask == null) {
            throw new NullPointerException("emptySkyYMask is marked non-null but is null");
        }
        if (emptyBlockYMask == null) {
            throw new NullPointerException("emptyBlockYMask is marked non-null but is null");
        }
        if (skyUpdates == null) {
            throw new NullPointerException("skyUpdates is marked non-null but is null");
        }
        if (blockUpdates == null) {
            throw new NullPointerException("blockUpdates is marked non-null but is null");
        }
        for (byte[] content : skyUpdates) {
            if (content.length == 2048) continue;
            throw new IllegalArgumentException("All arrays in skyUpdates must be length of 2048!");
        }
        for (byte[] content : blockUpdates) {
            if (content.length == 2048) continue;
            throw new IllegalArgumentException("All arrays in blockUpdates must be length of 2048!");
        }
        this.x = x;
        this.z = z;
        this.lightData = new LightUpdateData(skyYMask, blockYMask, emptySkyYMask, emptyBlockYMask, skyUpdates, blockUpdates);
    }

    public ClientboundLightUpdatePacket(ByteBuf in) {
        this.x = MinecraftTypes.readVarInt(in);
        this.z = MinecraftTypes.readVarInt(in);
        this.lightData = MinecraftTypes.readLightUpdateData(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.x);
        MinecraftTypes.writeVarInt(out, this.z);
        MinecraftTypes.writeLightUpdateData(out, this.lightData);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    @lombok.NonNull
    public LightUpdateData getLightData() {
        return this.lightData;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundLightUpdatePacket)) {
            return false;
        }
        ClientboundLightUpdatePacket other = (ClientboundLightUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        LightUpdateData this$lightData = this.getLightData();
        LightUpdateData other$lightData = other.getLightData();
        return !(this$lightData == null ? other$lightData != null : !((Object)this$lightData).equals(other$lightData));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundLightUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        LightUpdateData $lightData = this.getLightData();
        result = result * 59 + ($lightData == null ? 43 : ((Object)$lightData).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundLightUpdatePacket(x=" + this.getX() + ", z=" + this.getZ() + ", lightData=" + String.valueOf(this.getLightData()) + ")";
    }

    public @NonNull ClientboundLightUpdatePacket withX(int x) {
        return this.x == x ? this : new ClientboundLightUpdatePacket(x, this.z, this.lightData);
    }

    public @NonNull ClientboundLightUpdatePacket withZ(int z) {
        return this.z == z ? this : new ClientboundLightUpdatePacket(this.x, z, this.lightData);
    }

    public @NonNull ClientboundLightUpdatePacket withLightData(@lombok.NonNull LightUpdateData lightData) {
        if (lightData == null) {
            throw new NullPointerException("lightData is marked non-null but is null");
        }
        return this.lightData == lightData ? this : new ClientboundLightUpdatePacket(this.x, this.z, lightData);
    }

    public ClientboundLightUpdatePacket(int x, int z, @lombok.NonNull LightUpdateData lightData) {
        if (lightData == null) {
            throw new NullPointerException("lightData is marked non-null but is null");
        }
        this.x = x;
        this.z = z;
        this.lightData = lightData;
    }
}

