/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.title;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundClearTitlesPacket
implements MinecraftPacket {
    private final boolean resetTimes;

    public ClientboundClearTitlesPacket(ByteBuf in) {
        this.resetTimes = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeBoolean(this.resetTimes);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public boolean isResetTimes() {
        return this.resetTimes;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundClearTitlesPacket)) {
            return false;
        }
        ClientboundClearTitlesPacket other = (ClientboundClearTitlesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isResetTimes() == other.isResetTimes();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundClearTitlesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isResetTimes() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundClearTitlesPacket(resetTimes=" + this.isResetTimes() + ")";
    }

    public @NonNull ClientboundClearTitlesPacket withResetTimes(boolean resetTimes) {
        return this.resetTimes == resetTimes ? this : new ClientboundClearTitlesPacket(resetTimes);
    }

    public ClientboundClearTitlesPacket(boolean resetTimes) {
        this.resetTimes = resetTimes;
    }
}

