/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;

public class LecternContainer
extends Container {
    private int currentBedrockPage = 0;
    private NbtMap blockEntityTag;
    private Vector3i position;
    private boolean isBookInPlayerInventory = false;

    public LecternContainer(String title, int id, int size, ContainerType containerType, PlayerInventory playerInventory) {
        super(title, id, size, containerType, playerInventory);
    }

    @Override
    public void setItem(int slot, @NonNull GeyserItemStack newItem, GeyserSession session) {
        if (this.isBookInPlayerInventory) {
            session.getPlayerInventory().setItem(slot, newItem, session);
        } else {
            super.setItem(slot, newItem, session);
        }
    }

    public void setFakeLecternBook(GeyserItemStack book, GeyserSession session) {
        this.isBookInPlayerInventory = true;
        super.setItem(0, book, session);
    }

    @Override
    public boolean shouldConfirmContainerClose() {
        return !this.isBookInPlayerInventory;
    }

    public int getCurrentBedrockPage() {
        return this.currentBedrockPage;
    }

    public NbtMap getBlockEntityTag() {
        return this.blockEntityTag;
    }

    public Vector3i getPosition() {
        return this.position;
    }

    public boolean isBookInPlayerInventory() {
        return this.isBookInPlayerInventory;
    }

    public void setCurrentBedrockPage(int currentBedrockPage) {
        this.currentBedrockPage = currentBedrockPage;
    }

    public void setBlockEntityTag(NbtMap blockEntityTag) {
        this.blockEntityTag = blockEntityTag;
    }

    public void setPosition(Vector3i position) {
        this.position = position;
    }
}

