/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.player;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.WallSkullBlock;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;

public class SkullPlayerEntity
extends AvatarEntity {
    private UUID skullUUID;
    private Vector3i skullPosition;

    public SkullPlayerEntity(GeyserSession session, long geyserId) {
        super(session, 0, geyserId, UUID.randomUUID(), EntityDefinitions.PLAYER, Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, "");
    }

    @Override
    protected void initializeMetadata() {
        this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(1.08f));
        this.dirtyMetadata.put(EntityDataTypes.HEIGHT, Float.valueOf(0.001f));
        this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(0.001f));
        this.setFlag(EntityFlag.CAN_SHOW_NAME, false);
        this.setFlag(EntityFlag.INVISIBLE, true);
    }

    public void updateSkull(SkullCache.Skull skull) {
        float rotation;
        this.skullPosition = skull.getPosition();
        if (!Objects.equals(skull.getTexturesProperty(), this.texturesProperty) || !Objects.equals(this.skullUUID, skull.getUuid())) {
            this.setFlag(EntityFlag.INVISIBLE, true);
            this.updateBedrockMetadata();
            this.skullUUID = skull.getUuid();
            this.setSkin(skull.getTexturesProperty(), false, () -> this.session.scheduleInEventLoop(() -> {
                this.setFlag(EntityFlag.INVISIBLE, false);
                this.updateBedrockMetadata();
            }, 250L, TimeUnit.MILLISECONDS));
        } else {
            this.setFlag(EntityFlag.INVISIBLE, false);
            this.updateBedrockMetadata();
        }
        float x = (float)skull.getPosition().getX() + 0.5f;
        float y = (float)skull.getPosition().getY() - 0.01f;
        float z = (float)skull.getPosition().getZ() + 0.5f;
        BlockState blockState = skull.getBlockState();
        if (blockState.block() instanceof WallSkullBlock) {
            y += 0.25f;
            Direction direction = blockState.getValue(Properties.HORIZONTAL_FACING);
            rotation = WallSkullBlock.getDegrees(direction);
            switch (direction) {
                case NORTH: {
                    z += 0.24f;
                    break;
                }
                case SOUTH: {
                    z -= 0.24f;
                    break;
                }
                case WEST: {
                    x += 0.24f;
                    break;
                }
                case EAST: {
                    x -= 0.24f;
                }
            }
        } else {
            rotation = (180.0f + (float)blockState.getValue(Properties.ROTATION_16, 0).intValue() * 22.5f) % 360.0f;
        }
        this.moveAbsolute(Vector3f.from(x, y, z), rotation, 0.0f, rotation, true, true);
    }

    public UUID getSkullUUID() {
        return this.skullUUID;
    }

    public Vector3i getSkullPosition() {
        return this.skullPosition;
    }
}

