/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.item;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum DyeColor {
    WHITE,
    ORANGE,
    MAGENTA,
    LIGHT_BLUE,
    YELLOW,
    LIME,
    PINK,
    GRAY,
    LIGHT_GRAY,
    CYAN,
    PURPLE,
    BLUE,
    BROWN,
    GREEN,
    RED,
    BLACK;

    private static final DyeColor[] VALUES;
    private final String javaIdentifier = this.name().toLowerCase(Locale.ROOT);

    public static @Nullable DyeColor getById(int id) {
        if (id >= 0 && id < VALUES.length) {
            return VALUES[id];
        }
        return null;
    }

    public static @Nullable DyeColor getByJavaIdentifier(String javaIdentifier) {
        for (DyeColor dyeColor : VALUES) {
            if (!dyeColor.javaIdentifier.equals(javaIdentifier)) continue;
            return dyeColor;
        }
        return null;
    }

    public String getJavaIdentifier() {
        return this.javaIdentifier;
    }

    static {
        VALUES = DyeColor.values();
    }
}

