/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.chest;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Generic9X3Container;
import org.geysermc.geyser.inventory.holder.BlockInventoryHolder;
import org.geysermc.geyser.inventory.holder.InventoryHolder;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.ChestType;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.chest.ChestInventoryTranslator;

public class SingleChestInventoryTranslator
extends ChestInventoryTranslator<Generic9X3Container> {
    private final InventoryHolder holder = new BlockInventoryHolder(Blocks.CHEST.defaultBlockState().withValue(Properties.CHEST_TYPE, ChestType.SINGLE), ContainerType.CONTAINER, new Block[]{Blocks.ENDER_CHEST, Blocks.TRAPPED_CHEST, Blocks.BARREL}){

        @Override
        protected boolean isValidBlock(GeyserSession session, Vector3i position, BlockState blockState) {
            if (blockState.is(Blocks.ENDER_CHEST) || blockState.is(Blocks.BARREL)) {
                return true;
            }
            if (!super.isValidBlock(session, position, blockState)) {
                return false;
            }
            if (blockState.getValue(Properties.CHEST_TYPE) != ChestType.SINGLE) {
                return false;
            }
            if (GameProtocol.is1_21_110orHigher(session)) {
                Direction facing = blockState.getValue(Properties.HORIZONTAL_FACING);
                Vector3i left = position.add((facing.getAxis() == Axis.X ? Direction.SOUTH : Direction.WEST).getUnitVector());
                Vector3i right = position.add((facing.getAxis() == Axis.X ? Direction.NORTH : Direction.EAST).getUnitVector());
                BlockState leftState = BlockState.of(GeyserImpl.getInstance().getWorldManager().getBlockAt(session, left));
                BlockState rightState = BlockState.of(GeyserImpl.getInstance().getWorldManager().getBlockAt(session, right));
                return !(leftState.is(blockState.block()) && leftState.getValue(Properties.HORIZONTAL_FACING) == facing || rightState.is(blockState.block()) && rightState.getValue(Properties.HORIZONTAL_FACING) == facing);
            }
            return true;
        }
    };

    public SingleChestInventoryTranslator(int size) {
        super(size, 27);
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Generic9X3Container container) {
        return this.holder.prepareInventory(session, container);
    }

    @Override
    public void openInventory(GeyserSession session, Generic9X3Container container) {
        this.holder.openInventory(session, container);
    }

    @Override
    public void closeInventory(GeyserSession session, Generic9X3Container container, boolean force) {
        this.holder.closeInventory(session, container, ContainerType.CONTAINER);
    }

    @Override
    public Generic9X3Container createInventory(GeyserSession session, String name, int windowId, org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType containerType) {
        return new Generic9X3Container(session, name, windowId, this.size, containerType);
    }

    @Override
    protected ContainerSlotType slotType(Generic9X3Container generic9X3Container) {
        if (generic9X3Container.isBarrel()) {
            return ContainerSlotType.BARREL;
        }
        return super.slotType(generic9X3Container);
    }
}

