/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.player;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.level.notify.GameEventValue;

public enum GameMode implements GameEventValue
{
    SURVIVAL,
    CREATIVE,
    ADVENTURE,
    SPECTATOR;

    private static final GameMode[] VALUES;

    public static GameMode byId(int id) {
        return id >= 0 && id < VALUES.length ? VALUES[id] : VALUES[0];
    }

    public static @Nullable GameMode byNullableId(int id) {
        return id == -1 ? null : GameMode.byId(id);
    }

    public static int toNullableId(@Nullable GameMode gameMode) {
        if (gameMode != null) {
            return gameMode.ordinal();
        }
        return -1;
    }

    static {
        VALUES = GameMode.values();
    }
}

