/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ServerboundContainerSlotStateChangedPacket
implements MinecraftPacket {
    private final int slotId;
    private final int containerId;
    private final boolean newState;

    public ServerboundContainerSlotStateChangedPacket(ByteBuf in) {
        this.slotId = MinecraftTypes.readVarInt(in);
        this.containerId = MinecraftTypes.readVarInt(in);
        this.newState = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.slotId);
        MinecraftTypes.writeVarInt(out, this.containerId);
        out.writeBoolean(this.newState);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public boolean isNewState() {
        return this.newState;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundContainerSlotStateChangedPacket)) {
            return false;
        }
        ServerboundContainerSlotStateChangedPacket other = (ServerboundContainerSlotStateChangedPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSlotId() != other.getSlotId()) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        return this.isNewState() == other.isNewState();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundContainerSlotStateChangedPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlotId();
        result = result * 59 + this.getContainerId();
        result = result * 59 + (this.isNewState() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundContainerSlotStateChangedPacket(slotId=" + this.getSlotId() + ", containerId=" + this.getContainerId() + ", newState=" + this.isNewState() + ")";
    }

    public @NonNull ServerboundContainerSlotStateChangedPacket withSlotId(int slotId) {
        return this.slotId == slotId ? this : new ServerboundContainerSlotStateChangedPacket(slotId, this.containerId, this.newState);
    }

    public @NonNull ServerboundContainerSlotStateChangedPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ServerboundContainerSlotStateChangedPacket(this.slotId, containerId, this.newState);
    }

    public @NonNull ServerboundContainerSlotStateChangedPacket withNewState(boolean newState) {
        return this.newState == newState ? this : new ServerboundContainerSlotStateChangedPacket(this.slotId, this.containerId, newState);
    }

    public ServerboundContainerSlotStateChangedPacket(int slotId, int containerId, boolean newState) {
        this.slotId = slotId;
        this.containerId = containerId;
        this.newState = newState;
    }
}

