/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ServerboundSignUpdatePacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Vector3i position;
    @lombok.NonNull
    private final String[] lines;
    private final boolean isFrontText;

    public ServerboundSignUpdatePacket(@lombok.NonNull Vector3i position, @lombok.NonNull String[] lines, boolean isFrontText) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (lines.length != 4) {
            throw new IllegalArgumentException("Lines must contain exactly 4 strings.");
        }
        this.position = position;
        this.lines = Arrays.copyOf(lines, lines.length);
        this.isFrontText = isFrontText;
    }

    public ServerboundSignUpdatePacket(ByteBuf in) {
        this.position = MinecraftTypes.readPosition(in);
        this.isFrontText = in.readBoolean();
        this.lines = new String[4];
        for (int count = 0; count < this.lines.length; ++count) {
            this.lines[count] = MinecraftTypes.readString(in);
        }
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writePosition(out, this.position);
        out.writeBoolean(this.isFrontText);
        for (String line : this.lines) {
            MinecraftTypes.writeString(out, line);
        }
    }

    @lombok.NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @lombok.NonNull
    public String[] getLines() {
        return this.lines;
    }

    public boolean isFrontText() {
        return this.isFrontText;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSignUpdatePacket)) {
            return false;
        }
        ServerboundSignUpdatePacket other = (ServerboundSignUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFrontText() != other.isFrontText()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        return Arrays.deepEquals(this.getLines(), other.getLines());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSignUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFrontText() ? 79 : 97);
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLines());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSignUpdatePacket(position=" + String.valueOf(this.getPosition()) + ", lines=" + Arrays.deepToString(this.getLines()) + ", isFrontText=" + this.isFrontText() + ")";
    }

    public @NonNull ServerboundSignUpdatePacket withPosition(@lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundSignUpdatePacket(position, this.lines, this.isFrontText);
    }

    public @NonNull ServerboundSignUpdatePacket withLines(@lombok.NonNull String[] lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        return this.lines == lines ? this : new ServerboundSignUpdatePacket(this.position, lines, this.isFrontText);
    }

    public @NonNull ServerboundSignUpdatePacket withFrontText(boolean isFrontText) {
        return this.isFrontText == isFrontText ? this : new ServerboundSignUpdatePacket(this.position, this.lines, isFrontText);
    }
}

