/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.chest;

import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.inventory.Generic9X3Container;
import org.geysermc.geyser.inventory.holder.BlockInventoryHolder;
import org.geysermc.geyser.inventory.holder.InventoryHolder;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.ChestType;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.chest.ChestInventoryTranslator;

public class SingleChestInventoryTranslator
extends ChestInventoryTranslator<Generic9X3Container> {
    private final InventoryHolder holder = new BlockInventoryHolder(Blocks.CHEST.defaultBlockState().withValue(Properties.CHEST_TYPE, ChestType.SINGLE), ContainerType.CONTAINER, new Block[]{Blocks.ENDER_CHEST, Blocks.TRAPPED_CHEST, Blocks.BARREL}){

        @Override
        protected boolean isValidBlock(BlockState blockState) {
            if (blockState.is(Blocks.ENDER_CHEST) || blockState.is(Blocks.BARREL)) {
                return true;
            }
            return super.isValidBlock(blockState) && blockState.getValue(Properties.CHEST_TYPE) == ChestType.SINGLE;
        }
    };

    public SingleChestInventoryTranslator(int size) {
        super(size, 27);
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Generic9X3Container container) {
        return this.holder.prepareInventory(session, container);
    }

    @Override
    public void openInventory(GeyserSession session, Generic9X3Container container) {
        this.holder.openInventory(session, container);
    }

    @Override
    public void closeInventory(GeyserSession session, Generic9X3Container container, boolean force) {
        this.holder.closeInventory(session, container, ContainerType.CONTAINER);
    }

    @Override
    public Generic9X3Container createInventory(GeyserSession session, String name, int windowId, org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType containerType) {
        return new Generic9X3Container(session, name, windowId, this.size, containerType);
    }

    @Override
    protected ContainerSlotType slotType(Generic9X3Container generic9X3Container) {
        if (generic9X3Container.isBarrel()) {
            return ContainerSlotType.BARREL;
        }
        return super.slotType(generic9X3Container);
    }
}

