/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2l;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.math.vector.Vector4l;
import org.cloudburstmc.math.vector.VectorNl;
import org.cloudburstmc.math.vector.Vectorl;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector3l
implements Vectorl,
Comparable<Vector3l>,
Serializable,
Cloneable {
    public static final Vector3l ZERO = Vector3l.from(0L, 0L, 0L);
    public static final Vector3l UNIT_X = Vector3l.from(1L, 0L, 0L);
    public static final Vector3l UNIT_Y = Vector3l.from(0L, 1L, 0L);
    public static final Vector3l UNIT_Z = Vector3l.from(0L, 0L, 1L);
    public static final Vector3l ONE = Vector3l.from(1L, 1L, 1L);
    public static final Vector3l RIGHT = UNIT_X;
    public static final Vector3l UP = UNIT_Y;
    public static final Vector3l FORWARD = UNIT_Z;

    public abstract long getX();

    public abstract long getY();

    public abstract long getZ();

    @Nonnull
    public Vector3l add(Vector3l v) {
        return this.add(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3l add(double x, double y, double z) {
        return this.add(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    @Nonnull
    public abstract Vector3l add(long var1, long var3, long var5);

    @Nonnull
    public Vector3l sub(Vector3l v) {
        return this.sub(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3l sub(double x, double y, double z) {
        return this.sub(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    @Nonnull
    public abstract Vector3l sub(long var1, long var3, long var5);

    @Nonnull
    public Vector3l mul(double a) {
        return this.mul(GenericMath.floor64(a));
    }

    @Override
    @Nonnull
    public Vector3l mul(long a) {
        return this.mul(a, a, a);
    }

    @Nonnull
    public Vector3l mul(Vector3l v) {
        return this.mul(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3l mul(double x, double y, double z) {
        return this.mul(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    @Nonnull
    public abstract Vector3l mul(long var1, long var3, long var5);

    @Nonnull
    public Vector3l div(double a) {
        return this.div(GenericMath.floor64(a));
    }

    @Override
    @Nonnull
    public Vector3l div(long a) {
        return this.div(a, a, a);
    }

    @Nonnull
    public Vector3l div(Vector3l v) {
        return this.div(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3l div(double x, double y, double z) {
        return this.div(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    @Nonnull
    public abstract Vector3l div(long var1, long var3, long var5);

    public long dot(Vector3l v) {
        return this.dot(v.getX(), v.getY(), v.getZ());
    }

    public long dot(double x, double y, double z) {
        return this.dot(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    public long dot(long x, long y, long z) {
        return this.getX() * x + this.getY() * y + this.getZ() * z;
    }

    @Nonnull
    public Vector3l project(Vector3l v) {
        return this.project(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3l project(double x, double y, double z) {
        return this.project(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    @Nonnull
    public abstract Vector3l project(long var1, long var3, long var5);

    @Nonnull
    public Vector3l cross(Vector3l v) {
        return this.cross(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3l cross(double x, double y, double z) {
        return this.cross(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    @Nonnull
    public abstract Vector3l cross(long var1, long var3, long var5);

    @Nonnull
    public Vector3l pow(double pow) {
        return this.pow(GenericMath.floor64(pow));
    }

    @Override
    @Nonnull
    public abstract Vector3l pow(long var1);

    @Override
    @Nonnull
    public abstract Vector3l abs();

    @Override
    @Nonnull
    public abstract Vector3l negate();

    @Nonnull
    public Vector3l min(Vector3l v) {
        return this.min(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3l min(double x, double y, double z) {
        return this.min(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    @Nonnull
    public abstract Vector3l min(long var1, long var3, long var5);

    @Nonnull
    public Vector3l max(Vector3l v) {
        return this.max(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3l max(double x, double y, double z) {
        return this.max(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    @Nonnull
    public abstract Vector3l max(long var1, long var3, long var5);

    public long distanceSquared(Vector3l v) {
        return this.distanceSquared(v.getX(), v.getY(), v.getZ());
    }

    public long distanceSquared(double x, double y, double z) {
        return this.distanceSquared(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    public long distanceSquared(long x, long y, long z) {
        long dx = this.getX() - x;
        long dy = this.getY() - y;
        long dz = this.getZ() - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distance(Vector3l v) {
        return this.distance(v.getX(), v.getY(), v.getZ());
    }

    public double distance(double x, double y, double z) {
        return this.distance(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    public double distance(long x, long y, long z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    @Nonnull
    public Vector3l up() {
        return this.up(1L);
    }

    @Nonnull
    public abstract Vector3l up(long var1);

    @Nonnull
    public Vector3l down() {
        return this.down(1L);
    }

    @Nonnull
    public abstract Vector3l down(long var1);

    @Nonnull
    public Vector3l north() {
        return this.north(1L);
    }

    @Nonnull
    public abstract Vector3l north(long var1);

    @Nonnull
    public Vector3l south() {
        return this.south(1L);
    }

    @Nonnull
    public abstract Vector3l south(long var1);

    @Nonnull
    public Vector3l east() {
        return this.east(1L);
    }

    @Nonnull
    public abstract Vector3l east(long var1);

    @Nonnull
    public Vector3l west() {
        return this.west(1L);
    }

    @Nonnull
    public abstract Vector3l west(long var1);

    @Override
    public long lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    @Override
    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    @Override
    public int getMinAxis() {
        return this.getX() < this.getY() ? (this.getX() < this.getZ() ? 0 : 2) : (this.getY() < this.getZ() ? 1 : 2);
    }

    @Override
    public int getMaxAxis() {
        return this.getX() < this.getY() ? (this.getY() < this.getZ() ? 2 : 1) : (this.getX() < this.getZ() ? 2 : 0);
    }

    @Nonnull
    public Vector2l toVector2() {
        return Vector2l.from(this);
    }

    @Nonnull
    public Vector2l toVector2(boolean useZ) {
        return Vector2l.from(this.getX(), useZ ? this.getZ() : this.getY());
    }

    @Nonnull
    public Vector4l toVector4() {
        return this.toVector4(0L);
    }

    @Nonnull
    public Vector4l toVector4(double w) {
        return this.toVector4(GenericMath.floor64(w));
    }

    @Nonnull
    public Vector4l toVector4(long w) {
        return Vector4l.from(this, w);
    }

    @Nonnull
    public VectorNl toVectorN() {
        return VectorNl.from(this);
    }

    @Override
    @Nonnull
    public long[] toArray() {
        return new long[]{this.getX(), this.getY(), this.getZ()};
    }

    @Override
    @Nonnull
    public Vector3i toInt() {
        return Vector3i.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3l toLong() {
        return Vector3l.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3f toFloat() {
        return Vector3f.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3d toDouble() {
        return Vector3d.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public int compareTo(Vector3l v) {
        return (int)(this.lengthSquared() - v.lengthSquared());
    }

    @Nonnull
    public Vector3l clone() {
        return Vector3l.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }

    @Nonnull
    public static Vector3l from(long n) {
        return Vectors.createVector3l(n, n, n);
    }

    @Nonnull
    public static Vector3l from(Vector2l v) {
        return Vector3l.from(v, 0L);
    }

    @Nonnull
    public static Vector3l from(Vector2l v, double z) {
        return Vector3l.from(v, GenericMath.floor64(z));
    }

    @Nonnull
    public static Vector3l from(Vector2l v, long z) {
        return Vector3l.from(v.getX(), v.getY(), z);
    }

    @Nonnull
    public static Vector3l from(Vector3l v) {
        return Vector3l.from(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public static Vector3l from(Vector4l v) {
        return Vector3l.from(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public static Vector3l from(VectorNl v) {
        return Vector3l.from(v.get(0), v.get(1), v.size() > 2 ? v.get(2) : 0L);
    }

    @Nonnull
    public static Vector3l from(double x, double y, double z) {
        return Vector3l.from(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z));
    }

    @Nonnull
    public static Vector3l from(long x, long y, long z) {
        return Vectors.createVector3l(x, y, z);
    }
}

