/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.api.bedrock.camera;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.IntRange;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.bedrock.camera.CameraEaseType;
import org.geysermc.geyser.api.bedrock.camera.CameraFade;

public interface CameraPosition {
    public @NonNull Vector3f position();

    public @Nullable CameraEaseType easeType();

    public @Nullable CameraFade cameraFade();

    public float easeSeconds();

    public @IntRange(from=-90L, to=90L) int rotationX();

    public int rotationY();

    public @Nullable Vector3f facingPosition();

    public boolean renderPlayerEffects();

    public boolean playerPositionForAudio();

    public static Builder builder() {
        return (Builder)GeyserApi.api().provider(Builder.class, new Object[0]);
    }

    public static interface Builder {
        public Builder cameraFade(@Nullable CameraFade var1);

        public Builder renderPlayerEffects(boolean var1);

        public Builder playerPositionForAudio(boolean var1);

        public Builder easeType(@Nullable CameraEaseType var1);

        public Builder easeSeconds(float var1);

        public Builder position(@NonNull Vector3f var1);

        public Builder rotationX(@IntRange(from=-90L, to=90L) int var1);

        public Builder rotationY(int var1);

        public Builder facingPosition(@Nullable Vector3f var1);

        public CameraPosition build();
    }
}

