/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data;

import org.cloudburstmc.protocol.common.util.Preconditions;

public class ScoreInfo {
    private final long scoreboardId;
    private final String objectiveId;
    private final int score;
    private final ScorerType type;
    private final String name;
    private final long entityId;

    public ScoreInfo(long scoreboardId, String objectiveId, int score) {
        this.scoreboardId = scoreboardId;
        this.objectiveId = objectiveId;
        this.score = score;
        this.type = ScorerType.INVALID;
        this.name = null;
        this.entityId = -1L;
    }

    public ScoreInfo(long scoreboardId, String objectiveId, int score, String name) {
        this.scoreboardId = scoreboardId;
        this.objectiveId = objectiveId;
        this.score = score;
        this.type = ScorerType.FAKE;
        this.name = name;
        this.entityId = -1L;
    }

    public ScoreInfo(long scoreboardId, String objectiveId, int score, ScorerType type, long entityId) {
        Preconditions.checkArgument(type == ScorerType.ENTITY || type == ScorerType.PLAYER, "Must be player or entity");
        this.scoreboardId = scoreboardId;
        this.objectiveId = objectiveId;
        this.score = score;
        this.type = type;
        this.entityId = entityId;
        this.name = null;
    }

    public long getScoreboardId() {
        return this.scoreboardId;
    }

    public String getObjectiveId() {
        return this.objectiveId;
    }

    public int getScore() {
        return this.score;
    }

    public ScorerType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScoreInfo)) {
            return false;
        }
        ScoreInfo other = (ScoreInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getScoreboardId() != other.getScoreboardId()) {
            return false;
        }
        if (this.getScore() != other.getScore()) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        String this$objectiveId = this.getObjectiveId();
        String other$objectiveId = other.getObjectiveId();
        if (this$objectiveId == null ? other$objectiveId != null : !this$objectiveId.equals(other$objectiveId)) {
            return false;
        }
        ScorerType this$type = this.getType();
        ScorerType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScoreInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $scoreboardId = this.getScoreboardId();
        result = result * 59 + (int)($scoreboardId >>> 32 ^ $scoreboardId);
        result = result * 59 + this.getScore();
        long $entityId = this.getEntityId();
        result = result * 59 + (int)($entityId >>> 32 ^ $entityId);
        String $objectiveId = this.getObjectiveId();
        result = result * 59 + ($objectiveId == null ? 43 : $objectiveId.hashCode());
        ScorerType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ScoreInfo(scoreboardId=" + this.getScoreboardId() + ", objectiveId=" + this.getObjectiveId() + ", score=" + this.getScore() + ", type=" + (Object)((Object)this.getType()) + ", name=" + this.getName() + ", entityId=" + this.getEntityId() + ")";
    }

    public static enum ScorerType {
        INVALID,
        PLAYER,
        ENTITY,
        FAKE;

    }
}

