/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.command.CommandData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandEnumConstraint;
import org.cloudburstmc.protocol.bedrock.data.command.CommandEnumData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandOverloadData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandParam;
import org.cloudburstmc.protocol.bedrock.data.command.CommandParamData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandPermission;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.lifecycle.GeyserRegisterPermissionsEvent;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.command.ExceptionHandlers;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.command.defaults.AdvancedTooltipsCommand;
import org.geysermc.geyser.command.defaults.AdvancementsCommand;
import org.geysermc.geyser.command.defaults.ConnectionTestCommand;
import org.geysermc.geyser.command.defaults.DumpCommand;
import org.geysermc.geyser.command.defaults.ExtensionsCommand;
import org.geysermc.geyser.command.defaults.HelpCommand;
import org.geysermc.geyser.command.defaults.ListCommand;
import org.geysermc.geyser.command.defaults.OffhandCommand;
import org.geysermc.geyser.command.defaults.PingCommand;
import org.geysermc.geyser.command.defaults.ReloadCommand;
import org.geysermc.geyser.command.defaults.SettingsCommand;
import org.geysermc.geyser.command.defaults.StatisticsCommand;
import org.geysermc.geyser.command.defaults.StopCommand;
import org.geysermc.geyser.command.defaults.VersionCommand;
import org.geysermc.geyser.event.type.GeyserDefineCommandsEventImpl;
import org.geysermc.geyser.extension.command.GeyserExtensionCommand;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.Command;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.CommandManager;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.component.CommandComponent;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.internal.CommandNode;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.parser.standard.EnumParser;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.parser.standard.IntegerParser;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.parser.standard.LiteralParser;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.parser.standard.StringArrayParser;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.suggestion.Suggestion;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.suggestion.SuggestionProvider;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.suggestion.Suggestions;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public class CommandRegistry
implements EventRegistrar {
    private static final String GEYSER_ROOT_PERMISSION = "geyser.command";
    public static final boolean STANDALONE_COMMAND_MANAGER = GeyserImpl.getInstance().getPlatformType() == PlatformType.STANDALONE || GeyserImpl.getInstance().getPlatformType() == PlatformType.VIAPROXY;
    protected final GeyserImpl geyser;
    private final CommandManager<GeyserCommandSource> cloud;
    private final boolean applyRootPermission;
    private final Map<String, GeyserCommand> commands = new Object2ObjectOpenHashMap<String, GeyserCommand>(13);
    private final Map<Extension, Map<String, GeyserCommand>> extensionCommands = new Object2ObjectOpenHashMap<Extension, Map<String, GeyserCommand>>(0);
    private final Map<String, Extension> extensionRootCommands = new Object2ObjectOpenHashMap<String, Extension>(0);
    protected final Map<String, TriState> permissionDefaults = new Object2ObjectOpenHashMap<String, TriState>(13);

    public CommandRegistry(GeyserImpl geyser, CommandManager<GeyserCommandSource> cloud) {
        this(geyser, cloud, true);
    }

    public CommandRegistry(GeyserImpl geyser, CommandManager<GeyserCommandSource> cloud, boolean applyRootPermission) {
        this.geyser = geyser;
        this.cloud = cloud;
        this.applyRootPermission = applyRootPermission;
        ExceptionHandlers.register(cloud);
        HelpCommand help = new HelpCommand("geyser", "help", "geyser.commands.help.desc", "geyser.command.help", this.commands);
        this.registerBuiltInCommand(help);
        this.buildRootCommand(GEYSER_ROOT_PERMISSION, help);
        this.registerBuiltInCommand(new ListCommand(geyser, "list", "geyser.commands.list.desc", "geyser.command.list"));
        this.registerBuiltInCommand(new ReloadCommand(geyser, "reload", "geyser.commands.reload.desc", "geyser.command.reload"));
        this.registerBuiltInCommand(new OffhandCommand("offhand", "geyser.commands.offhand.desc", "geyser.command.offhand"));
        this.registerBuiltInCommand(new DumpCommand(geyser, "dump", "geyser.commands.dump.desc", "geyser.command.dump"));
        this.registerBuiltInCommand(new VersionCommand(geyser, "version", "geyser.commands.version.desc", "geyser.command.version"));
        this.registerBuiltInCommand(new SettingsCommand("settings", "geyser.commands.settings.desc", "geyser.command.settings"));
        this.registerBuiltInCommand(new StatisticsCommand("statistics", "geyser.commands.statistics.desc", "geyser.command.statistics"));
        this.registerBuiltInCommand(new AdvancementsCommand("advancements", "geyser.commands.advancements.desc", "geyser.command.advancements"));
        this.registerBuiltInCommand(new AdvancedTooltipsCommand("tooltips", "geyser.commands.advancedtooltips.desc", "geyser.command.tooltips"));
        this.registerBuiltInCommand(new ConnectionTestCommand(geyser, "connectiontest", "geyser.commands.connectiontest.desc", "geyser.command.connectiontest"));
        this.registerBuiltInCommand(new PingCommand("ping", "geyser.commands.ping.desc", "geyser.command.ping"));
        if (this.geyser.getPlatformType() == PlatformType.STANDALONE) {
            this.registerBuiltInCommand(new StopCommand(geyser, "stop", "geyser.commands.stop.desc", "geyser.command.stop"));
        }
        if (!this.geyser.extensionManager().extensions().isEmpty()) {
            this.registerBuiltInCommand(new ExtensionsCommand(this.geyser, "extensions", "geyser.commands.extensions.desc", "geyser.command.extensions"));
        }
        GeyserDefineCommandsEventImpl defineCommandsEvent = new GeyserDefineCommandsEventImpl(this.commands){

            @Override
            public void register(@NonNull org.geysermc.geyser.api.command.Command command) {
                if (!(command instanceof GeyserExtensionCommand)) {
                    throw new IllegalArgumentException("Expected GeyserExtensionCommand as part of command registration but got " + String.valueOf(command) + "! Did you use the Command builder properly?");
                }
                GeyserExtensionCommand extensionCommand = (GeyserExtensionCommand)command;
                CommandRegistry.this.registerExtensionCommand(extensionCommand.extension(), extensionCommand);
            }
        };
        this.geyser.eventBus().fire(defineCommandsEvent);
        for (Map.Entry<Extension, Map<String, GeyserCommand>> entry : this.extensionCommands.entrySet()) {
            Extension extension = entry.getKey();
            this.extensionRootCommands.put(extension.rootCommand(), extension);
            String id = extension.description().id();
            HelpCommand extensionHelp = new HelpCommand(extension.rootCommand(), "help", "geyser.commands.exthelp.desc", "geyser.command.exthelp." + id, entry.getValue());
            this.registerExtensionCommand(extension, extensionHelp);
            this.buildRootCommand("geyser.extension." + id + ".command", extensionHelp);
        }
        geyser.eventBus().subscribe(this, GeyserRegisterPermissionsEvent.class, this::onRegisterPermissions);
    }

    public @NonNull Collection<String> rootCommands() {
        return this.cloud.rootCommands();
    }

    private void registerBuiltInCommand(GeyserCommand command) {
        this.register(command, this.commands);
    }

    private void registerExtensionCommand(@NonNull Extension extension, @NonNull GeyserCommand command) {
        this.register(command, this.extensionCommands.computeIfAbsent(extension, e -> new HashMap()));
    }

    protected void register(GeyserCommand command, Map<String, GeyserCommand> commands) {
        String root = command.rootCommand();
        String name = command.name();
        if (commands.containsKey(name)) {
            throw new IllegalArgumentException("Command with root=%s, name=%s already registered".formatted(root, name));
        }
        command.register(this.cloud);
        commands.put(name, command);
        this.geyser.getLogger().debug(GeyserLocale.getLocaleStringLog("geyser.commands.registered", root + " " + name));
        for (String alias : command.aliases()) {
            commands.put(alias, command);
        }
        String permission = command.permission();
        TriState defaultValue = command.permissionDefault();
        if (!permission.isBlank() && defaultValue != null) {
            TriState existingDefault = this.permissionDefaults.get(permission);
            if (existingDefault != null && existingDefault != defaultValue) {
                this.geyser.getLogger().debug("Overriding permission default %s:%s with %s".formatted(new Object[]{permission, existingDefault, defaultValue}));
            }
            this.permissionDefaults.put(permission, defaultValue);
        }
    }

    private void buildRootCommand(String permission, HelpCommand help) {
        Command.Builder builder = this.cloud.commandBuilder(help.rootCommand(), new String[0]);
        if (this.applyRootPermission) {
            builder = builder.permission(permission);
            this.permissionDefaults.put(permission, TriState.TRUE);
        }
        this.cloud.command(builder.handler(context -> {
            GeyserCommandSource source = (GeyserCommandSource)context.sender();
            if (source.hasPermission(help.permission())) {
                help.execute(source);
            } else if (STANDALONE_COMMAND_MANAGER && source instanceof GeyserSession) {
                GeyserSession session = (GeyserSession)source;
                session.sendCommand(context.rawInput().input());
            } else {
                source.sendLocaleString("geyser.command.permission_fail");
            }
        }));
    }

    protected void onRegisterPermissions(GeyserRegisterPermissionsEvent event) {
        for (Map.Entry<String, TriState> permission : this.permissionDefaults.entrySet()) {
            event.register(permission.getKey(), permission.getValue());
        }
    }

    public boolean hasPermission(GeyserCommandSource source, String permission) {
        return permission.isBlank() || this.cloud.hasPermission(source, permission);
    }

    public @NonNull String description(@NonNull String command, @NonNull String locale) {
        if (command.equals("geyser")) {
            return GeyserLocale.getPlayerLocaleString("geyser.command.root.geyser", locale);
        }
        Extension extension = this.extensionRootCommands.get(command);
        if (extension != null) {
            return GeyserLocale.getPlayerLocaleString("geyser.command.root.extension", locale, extension.name());
        }
        return "";
    }

    public void runCommand(@NonNull GeyserCommandSource source, @NonNull String command) {
        this.cloud.commandExecutor().executeCommand(source, command);
    }

    public Suggestions<GeyserCommandSource, ? extends Suggestion> suggestionsFor(GeyserCommandSource source, String input) {
        return this.cloud.suggestionFactory().suggestImmediately(source, input);
    }

    public void export(GeyserSession session, List<CommandData> bedrockCommands, Set<String> knownAliases) {
        this.cloud.commandTree().rootNodes().forEach(commandTree -> {
            Command command = commandTree.command();
            if (command == null || session.hasPermission(command.commandPermission().permissionString())) {
                CommandComponent rootComponent = commandTree.component();
                String name = rootComponent.name();
                if (!knownAliases.add(name)) {
                    return;
                }
                LinkedHashMap<String, Set<CommandEnumConstraint>> values = new LinkedHashMap<String, Set<CommandEnumConstraint>>();
                for (String s : rootComponent.aliases()) {
                    values.put(s, EnumSet.of(CommandEnumConstraint.ALLOW_ALIASES));
                }
                CommandEnumData aliases = new CommandEnumData(name + "Aliases", values, false);
                ArrayList data = new ArrayList();
                for (CommandNode<GeyserCommandSource> commandNode : commandTree.children()) {
                    List<List<CommandParamData>> params = this.createParamData(session, commandNode);
                    params.forEach(param -> data.add(new CommandOverloadData(false, (CommandParamData[])param.toArray(CommandParamData[]::new))));
                }
                CommandData bedrockCommand = new CommandData(name, rootComponent.description().textDescription(), Set.of(CommandData.Flag.NOT_CHEAT), CommandPermission.ANY, aliases, Collections.emptyList(), data.toArray(new CommandOverloadData[0]));
                bedrockCommands.add(bedrockCommand);
            }
        });
    }

    private List<List<CommandParamData>> createParamData(GeyserSession session, CommandNode<GeyserCommandSource> node) {
        Command<GeyserCommandSource> command = node.command();
        if (command != null && !session.hasPermission(command.commandPermission().permissionString())) {
            return Collections.emptyList();
        }
        CommandParamData data = new CommandParamData();
        CommandComponent<GeyserCommandSource> component = node.component();
        data.setName(component.name());
        data.setOptional(component.optional());
        SuggestionProvider<GeyserCommandSource> suggestionProvider = component.suggestionProvider();
        if (suggestionProvider instanceof LiteralParser) {
            LiteralParser parser = (LiteralParser)suggestionProvider;
            LinkedHashMap<String, Set<CommandEnumConstraint>> values = new LinkedHashMap<String, Set<CommandEnumConstraint>>();
            for (String alias : parser.aliases()) {
                values.put(alias, Set.of());
            }
            data.setEnumData(new CommandEnumData(component.name(), values, false));
        } else if (suggestionProvider instanceof IntegerParser) {
            data.setType(CommandParam.INT);
        } else if (suggestionProvider instanceof EnumParser) {
            EnumParser parser = (EnumParser)suggestionProvider;
            LinkedHashMap<String, Set<CommandEnumConstraint>> map = new LinkedHashMap<String, Set<CommandEnumConstraint>>();
            for (Enum e : parser.acceptedValues()) {
                map.put(e.name().toLowerCase(Locale.ROOT), Set.of());
            }
            data.setEnumData(new CommandEnumData(component.name().toLowerCase(Locale.ROOT), map, false));
        } else if (component.parser() instanceof StringArrayParser) {
            data.setType(CommandParam.TEXT);
        } else {
            data.setType(CommandParam.STRING);
        }
        List<CommandNode<GeyserCommandSource>> children = node.children();
        if (children.isEmpty()) {
            ArrayList<CommandParamData> list2 = new ArrayList<CommandParamData>();
            list2.add(data);
            return Collections.singletonList(list2);
        }
        ArrayList<List<CommandParamData>> collectiveData = new ArrayList<List<CommandParamData>>();
        for (CommandNode<GeyserCommandSource> child : children) {
            collectiveData.addAll(this.createParamData(session, child));
        }
        collectiveData.forEach(list -> list.add(0, data));
        return collectiveData;
    }
}

