/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block;

import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockPermutation;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.component.CustomBlockComponents;
import org.geysermc.geyser.api.block.custom.property.CustomBlockProperty;
import org.geysermc.geyser.api.block.custom.property.PropertyType;
import org.geysermc.geyser.api.util.CreativeCategory;
import org.geysermc.geyser.level.block.GeyserCustomBlockProperty;
import org.geysermc.geyser.level.block.GeyserCustomBlockState;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.ObjectLists;

public class GeyserCustomBlockData
implements CustomBlockData {
    private final String name;
    private final boolean includedInCreativeInventory;
    private final CreativeCategory creativeCategory;
    private final String creativeGroup;
    private final CustomBlockComponents components;
    private final Map<String, CustomBlockProperty<?>> properties;
    private final List<CustomBlockPermutation> permutations;
    private final Map<String, Object> defaultProperties;

    GeyserCustomBlockData(Builder builder) {
        this.name = builder.name;
        if (this.name == null) {
            throw new IllegalStateException("Name must be set");
        }
        this.includedInCreativeInventory = builder.includedInCreativeInventory;
        this.creativeCategory = builder.creativeCategory;
        this.creativeGroup = builder.creativeGroup;
        this.components = builder.components;
        if (!builder.properties.isEmpty()) {
            this.properties = Object2ObjectMaps.unmodifiable(new Object2ObjectArrayMap(builder.properties));
            Object2ObjectOpenHashMap defaultProperties = new Object2ObjectOpenHashMap(this.properties.size());
            for (CustomBlockProperty<?> property : this.properties.values()) {
                if (property.values().size() > 16) {
                    GeyserImpl.getInstance().getLogger().warning(property.name() + " contains more than 16 values, but BDS specifies it should not. This may break in future versions.");
                }
                if (property.values().stream().distinct().count() != (long)property.values().size()) {
                    throw new IllegalStateException(property.name() + " has duplicate values.");
                }
                if (property.values().isEmpty()) {
                    throw new IllegalStateException(property.name() + " contains no values.");
                }
                defaultProperties.put(property.name(), property.values().get(0));
            }
            this.defaultProperties = Object2ObjectMaps.unmodifiable(defaultProperties);
        } else {
            this.properties = Object2ObjectMaps.emptyMap();
            this.defaultProperties = Object2ObjectMaps.emptyMap();
        }
        this.permutations = !builder.permutations.isEmpty() ? List.of(builder.permutations.toArray(new CustomBlockPermutation[0])) : ObjectLists.emptyList();
    }

    @Override
    public @NonNull String name() {
        return this.name;
    }

    @Override
    public @NonNull String identifier() {
        return "geyser_custom:" + this.name;
    }

    @Override
    public boolean includedInCreativeInventory() {
        return this.includedInCreativeInventory;
    }

    @Override
    public @Nullable CreativeCategory creativeCategory() {
        return this.creativeCategory;
    }

    @Override
    public @Nullable String creativeGroup() {
        return this.creativeGroup;
    }

    @Override
    public CustomBlockComponents components() {
        return this.components;
    }

    @Override
    public @NonNull Map<String, CustomBlockProperty<?>> properties() {
        return this.properties;
    }

    @Override
    public @NonNull List<CustomBlockPermutation> permutations() {
        return this.permutations;
    }

    @Override
    public @NonNull CustomBlockState defaultBlockState() {
        return new GeyserCustomBlockState(this, this.defaultProperties);
    }

    @Override
    public @NonNull CustomBlockState.Builder blockStateBuilder() {
        return new GeyserCustomBlockState.Builder(this);
    }

    public GeyserCustomBlockData(String name, boolean includedInCreativeInventory, CreativeCategory creativeCategory, String creativeGroup, CustomBlockComponents components, Map<String, CustomBlockProperty<?>> properties, List<CustomBlockPermutation> permutations, Map<String, Object> defaultProperties) {
        this.name = name;
        this.includedInCreativeInventory = includedInCreativeInventory;
        this.creativeCategory = creativeCategory;
        this.creativeGroup = creativeGroup;
        this.components = components;
        this.properties = properties;
        this.permutations = permutations;
        this.defaultProperties = defaultProperties;
    }

    public static class Builder
    implements CustomBlockData.Builder {
        private String name;
        private boolean includedInCreativeInventory;
        private CreativeCategory creativeCategory;
        private String creativeGroup;
        private CustomBlockComponents components;
        private final Object2ObjectMap<String, CustomBlockProperty<?>> properties = new Object2ObjectOpenHashMap();
        private List<CustomBlockPermutation> permutations = ObjectLists.emptyList();

        @Override
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder includedInCreativeInventory(boolean includedInCreativeInventory) {
            this.includedInCreativeInventory = includedInCreativeInventory;
            return this;
        }

        @Override
        public Builder creativeCategory(@Nullable CreativeCategory creativeCategory) {
            this.creativeCategory = creativeCategory;
            return this;
        }

        @Override
        public Builder creativeGroup(@Nullable String creativeGroup) {
            this.creativeGroup = creativeGroup;
            return this;
        }

        @Override
        public Builder components(@NonNull CustomBlockComponents components) {
            this.components = components;
            return this;
        }

        @Override
        public Builder booleanProperty(@NonNull String propertyName) {
            this.properties.put(propertyName, new GeyserCustomBlockProperty<Byte>(propertyName, List.of(Byte.valueOf((byte)0), Byte.valueOf((byte)1)), PropertyType.booleanProp()));
            return this;
        }

        @Override
        public Builder intProperty(@NonNull String propertyName, List<Integer> values) {
            this.properties.put(propertyName, new GeyserCustomBlockProperty<Integer>(propertyName, values, PropertyType.integerProp()));
            return this;
        }

        @Override
        public Builder stringProperty(@NonNull String propertyName, List<String> values) {
            this.properties.put(propertyName, new GeyserCustomBlockProperty<String>(propertyName, values, PropertyType.stringProp()));
            return this;
        }

        @Override
        public Builder permutations(@NonNull List<CustomBlockPermutation> permutations) {
            this.permutations = permutations;
            return this;
        }

        @Override
        public CustomBlockData build() {
            return new GeyserCustomBlockData(this);
        }
    }
}

