/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.packet.BlockPickRequestPacket;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundPickItemFromBlockPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundPickItemFromEntityPacket;

@Translator(packet=BlockPickRequestPacket.class)
public class BedrockBlockPickRequestTranslator
extends PacketTranslator<BlockPickRequestPacket> {
    @Override
    public void translate(GeyserSession session, BlockPickRequestPacket packet) {
        Vector3i vector = packet.getBlockPosition();
        BlockState blockToPick = session.getGeyser().getWorldManager().blockAt(session, vector.getX(), vector.getY(), vector.getZ());
        if (blockToPick.is(Blocks.AIR)) {
            ItemFrameEntity entity = ItemFrameEntity.getItemFrameEntity(session, packet.getBlockPosition());
            if (entity != null) {
                session.sendDownstreamGamePacket(new ServerboundPickItemFromEntityPacket(entity.javaId(), packet.isAddUserData()));
            }
            return;
        }
        boolean addExtraData = packet.isAddUserData() && blockToPick.block().hasBlockEntity();
        session.sendDownstreamGamePacket(new ServerboundPickItemFromBlockPacket(vector, addExtraData));
    }
}

