/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.command.GeyserPermission;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.exception.ArgumentParseException;
import org.incendo.cloud.exception.CommandExecutionException;
import org.incendo.cloud.exception.InvalidCommandSenderException;
import org.incendo.cloud.exception.InvalidSyntaxException;
import org.incendo.cloud.exception.NoPermissionException;
import org.incendo.cloud.exception.NoSuchCommandException;
import org.incendo.cloud.exception.handling.ExceptionController;
import org.incendo.cloud.permission.PermissionResult;

final class ExceptionHandlers {
    static final String PERMISSION_FAIL_LANG_KEY = "geyser.command.permission_fail";
    private final ExceptionController<GeyserCommandSource> controller;

    private ExceptionHandlers(ExceptionController<GeyserCommandSource> controller) {
        this.controller = controller;
    }

    static void register(CommandManager<GeyserCommandSource> manager) {
        new ExceptionHandlers((ExceptionController<GeyserCommandSource>)manager.exceptionController()).register();
    }

    private void register() {
        this.controller.clearHandlers();
        this.registerExceptionHandler(InvalidSyntaxException.class, (ctx, e) -> ((GeyserCommandSource)ctx.sender()).sendLocaleString("geyser.command.invalid_syntax", e.correctSyntax()));
        this.registerExceptionHandler(InvalidCommandSenderException.class, (ctx, e) -> {
            Type type = (Type)e.requiredSenderTypes().iterator().next();
            String typeString = GenericTypeReflector.getTypeName((Type)type);
            ((GeyserCommandSource)ctx.sender()).sendLocaleString("geyser.command.invalid_sender", e.commandSender().getClass().getSimpleName(), typeString);
        });
        this.registerExceptionHandler(NoPermissionException.class, ExceptionHandlers::handleNoPermission);
        this.registerExceptionHandler(NoSuchCommandException.class, (ctx, e) -> {
            Object patt4231$temp;
            if (CommandRegistry.STANDALONE_COMMAND_MANAGER && (patt4231$temp = ctx.sender()) instanceof GeyserSession) {
                GeyserSession session = (GeyserSession)patt4231$temp;
                session.sendCommandPacket(ctx.rawInput().input());
            } else {
                ((GeyserCommandSource)ctx.sender()).sendLocaleString("geyser.command.not_found");
            }
        });
        this.registerExceptionHandler(ArgumentParseException.class, (ctx, e) -> ((GeyserCommandSource)ctx.sender()).sendLocaleString("geyser.command.invalid_argument", e.getCause().getMessage()));
        this.registerExceptionHandler(CommandExecutionException.class, (ctx, e) -> ExceptionHandlers.handleUnexpectedThrowable((GeyserCommandSource)ctx.sender(), e.getCause()));
        this.registerExceptionHandler(Throwable.class, (ctx, e) -> ExceptionHandlers.handleUnexpectedThrowable((GeyserCommandSource)ctx.sender(), e.getCause()));
    }

    private <E extends Throwable> void registerExceptionHandler(Class<E> type, BiConsumer<CommandContext<GeyserCommandSource>, E> handler) {
        this.controller.registerHandler(type, context -> handler.accept(context.context(), context.exception()));
    }

    private static void handleNoPermission(CommandContext<GeyserCommandSource> context, NoPermissionException exception) {
        GeyserCommandSource source = (GeyserCommandSource)context.sender();
        if (CommandRegistry.STANDALONE_COMMAND_MANAGER && source instanceof GeyserSession) {
            GeyserSession session = (GeyserSession)source;
            session.sendCommandPacket(context.rawInput().input());
            return;
        }
        PermissionResult permissionResult = exception.permissionResult();
        if (permissionResult instanceof GeyserPermission.Result) {
            GeyserPermission.Result result = (GeyserPermission.Result)permissionResult;
            if (result.meta() == GeyserPermission.Result.Meta.NOT_BEDROCK) {
                source.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.command.bedrock_only", source.locale()));
                return;
            }
            if (result.meta() == GeyserPermission.Result.Meta.NOT_PLAYER) {
                source.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.command.player_only", source.locale()));
                return;
            }
        } else {
            GeyserLogger logger = GeyserImpl.getInstance().getLogger();
            if (logger.isDebug()) {
                logger.debug("Expected a GeyserPermission.Result for %s but instead got %s from %s".formatted(exception.currentChain(), exception.permissionResult(), exception.missingPermission()));
            }
        }
        source.sendLocaleString(PERMISSION_FAIL_LANG_KEY);
    }

    private static void handleUnexpectedThrowable(GeyserCommandSource source, Throwable throwable) {
        source.sendMessage(MinecraftLocale.getLocaleString("command.failed", source.locale()));
        GeyserImpl.getInstance().getLogger().error("Exception while executing command handler", throwable);
    }
}

