/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.neoforge;

import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.GameShuttingDownEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import org.geysermc.geyser.command.CommandSourceConverter;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.platform.mod.GeyserModBootstrap;
import org.geysermc.geyser.platform.mod.GeyserModUpdateListener;
import org.geysermc.geyser.platform.mod.command.ModCommandSource;
import org.geysermc.geyser.platform.neoforge.GeyserNeoForgeCommandRegistry;
import org.geysermc.geyser.platform.neoforge.GeyserNeoForgePlatform;
import org.geysermc.geyser.platform.neoforge.PermissionUtils;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.neoforge.NeoForgeServerCommandManager;

@Mod(value="geyser_neoforge")
public class GeyserNeoForgeBootstrap
extends GeyserModBootstrap {
    public GeyserNeoForgeBootstrap(ModContainer container) {
        super(new GeyserNeoForgePlatform(container));
        if (this.isServer()) {
            NeoForge.EVENT_BUS.addListener(this::onServerStarted);
        } else {
            NeoForge.EVENT_BUS.addListener(this::onClientStopping);
        }
        NeoForge.EVENT_BUS.addListener(this::onServerStopping);
        NeoForge.EVENT_BUS.addListener(this::onPlayerJoin);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::onPermissionGather);
        this.onGeyserInitialize();
        CommandSourceConverter<CommandSourceStack> sourceConverter = CommandSourceConverter.layered(CommandSourceStack.class, id -> this.getServer().getPlayerList().getPlayer(id), ServerPlayer::createCommandSourceStack, () -> this.getServer().createCommandSourceStack(), ModCommandSource::new);
        NeoForgeServerCommandManager cloud = new NeoForgeServerCommandManager(ExecutionCoordinator.simpleCoordinator(), sourceConverter);
        GeyserNeoForgeCommandRegistry registry = new GeyserNeoForgeCommandRegistry(this.getGeyser(), (CommandManager<GeyserCommandSource>)cloud);
        this.setCommandRegistry(registry);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, registry::onPermissionGatherForUndefined);
    }

    private void onServerStarted(ServerStartedEvent event) {
        this.setServer(event.getServer());
        this.onGeyserEnable();
    }

    private void onServerStopping(ServerStoppingEvent event) {
        if (this.isServer()) {
            this.onGeyserShutdown();
        } else {
            this.onGeyserDisable();
        }
    }

    private void onClientStopping(GameShuttingDownEvent ignored) {
        this.onGeyserShutdown();
    }

    private void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            GeyserModUpdateListener.onPlayReady(player2);
        }
    }

    @Override
    public boolean isServer() {
        return FMLLoader.getCurrent().getDist().isDedicatedServer();
    }

    private void onPermissionGather(PermissionGatherEvent.Nodes event) {
        this.getGeyser().eventBus().fire((permission, defaultValue) -> {
            Objects.requireNonNull(permission, "permission");
            Objects.requireNonNull(defaultValue, "permission default for " + permission);
            if (permission.isBlank()) {
                return;
            }
            PermissionUtils.register(permission, defaultValue, event);
        });
    }
}

