/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.nbt.NbtUtils;
import org.cloudburstmc.protocol.bedrock.codec.v766.Bedrock_v766;
import org.cloudburstmc.protocol.bedrock.codec.v776.Bedrock_v776;
import org.cloudburstmc.protocol.bedrock.codec.v786.Bedrock_v786;
import org.cloudburstmc.protocol.bedrock.codec.v800.Bedrock_v800;
import org.cloudburstmc.protocol.bedrock.codec.v818.Bedrock_v818;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.SimpleItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemVersion;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.NonVanillaCustomBlockData;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.item.custom.NonVanillaCustomItemData;
import org.geysermc.geyser.inventory.item.StoredItemMappings;
import org.geysermc.geyser.item.GeyserCustomMappingData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.populator.CreativeItemRegistryPopulator;
import org.geysermc.geyser.registry.populator.CustomItemRegistryPopulator;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.registry.type.GeyserMappingItem;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.registry.type.NonVanillaItemRegistration;
import org.geysermc.geyser.registry.type.PaletteItem;
import org.geysermc.geyser.shaded.com.fasterxml.jackson.core.type.TypeReference;

public class ItemRegistryPopulator {
    public static void populate() {
        ObjectArrayList nonVanillaCustomItems;
        NbtMap vanillaComponents;
        Map<String, GeyserMappingItem> items;
        HashMap<Item, Item> itemFallbacks = new HashMap<Item, Item>();
        itemFallbacks.put(Items.BUSH, Items.SHORT_GRASS);
        itemFallbacks.put(Items.CACTUS_FLOWER, Items.BUBBLE_CORAL_FAN);
        itemFallbacks.put(Items.FIREFLY_BUSH, Items.SHORT_GRASS);
        itemFallbacks.put(Items.LEAF_LITTER, Items.PINK_PETALS);
        itemFallbacks.put(Items.SHORT_DRY_GRASS, Items.DEAD_BUSH);
        itemFallbacks.put(Items.TALL_DRY_GRASS, Items.TALL_GRASS);
        itemFallbacks.put(Items.WILDFLOWERS, Items.PINK_PETALS);
        itemFallbacks.put(Items.TEST_BLOCK, Items.STRUCTURE_BLOCK);
        itemFallbacks.put(Items.TEST_INSTANCE_BLOCK, Items.JIGSAW);
        itemFallbacks.put(Items.BLUE_EGG, Items.EGG);
        itemFallbacks.put(Items.BROWN_EGG, Items.EGG);
        ArrayList<PaletteVersion> paletteVersions = new ArrayList<PaletteVersion>(5);
        paletteVersions.add(new PaletteVersion("1_21_50", Bedrock_v766.CODEC.getProtocolVersion(), itemFallbacks, (item, mapping) -> mapping));
        paletteVersions.add(new PaletteVersion("1_21_60", Bedrock_v776.CODEC.getProtocolVersion(), itemFallbacks, (item, mapping) -> mapping));
        paletteVersions.add(new PaletteVersion("1_21_70", Bedrock_v786.CODEC.getProtocolVersion()));
        paletteVersions.add(new PaletteVersion("1_21_80", Bedrock_v800.CODEC.getProtocolVersion()));
        paletteVersions.add(new PaletteVersion("1_21_90", Bedrock_v818.CODEC.getProtocolVersion()));
        GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
        TypeReference<Map<String, GeyserMappingItem>> mappingItemsType = new TypeReference<Map<String, GeyserMappingItem>>(){};
        try (InputStream stream = bootstrap.getResourceOrThrow("mappings/items.json");){
            items = GeyserImpl.JSON_MAPPER.readValue(stream, mappingItemsType);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java runtime item IDs", e);
        }
        try (InputStream stream = bootstrap.getResourceOrThrow("bedrock/item_components.nbt");){
            vanillaComponents = (NbtMap)NbtUtils.createGZIPReader((InputStream)stream, (boolean)true, (boolean)true).readTag();
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Bedrock item components", e);
        }
        boolean customItemsAllowed = GeyserImpl.getInstance().getConfig().isAddNonBedrockItems();
        ListMultimap customItems = MultimapBuilder.hashKeys().arrayListValues().build();
        ObjectArrayList objectArrayList = nonVanillaCustomItems = customItemsAllowed ? new ObjectArrayList() : Collections.emptyList();
        if (customItemsAllowed) {
            CustomItemRegistryPopulator.populate(items, (Multimap<String, CustomItemData>)customItems, (List<NonVanillaCustomItemData>)nonVanillaCustomItems);
        }
        boolean firstMappingsPass = true;
        for (PaletteVersion palette : paletteVersions) {
            ItemDefinition lightBlock;
            List<PaletteItem> itemEntries;
            TypeReference<List<PaletteItem>> paletteEntriesType = new TypeReference<List<PaletteItem>>(){};
            try (InputStream stream = bootstrap.getResourceOrThrow(String.format("bedrock/runtime_item_states.%s.json", palette.version()));){
                itemEntries = GeyserImpl.JSON_MAPPER.readValue(stream, paletteEntriesType);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load Bedrock runtime item IDs", e);
            }
            int nextFreeBedrockId = 0;
            ObjectArrayList componentItemData = new ObjectArrayList();
            Int2ObjectOpenHashMap registry = new Int2ObjectOpenHashMap();
            Object2ObjectLinkedOpenHashMap definitions = new Object2ObjectLinkedOpenHashMap();
            for (PaletteItem entry : itemEntries) {
                NbtMap components;
                int id = entry.getId();
                if (id >= nextFreeBedrockId) {
                    nextFreeBedrockId = id + 1;
                }
                if ((components = vanillaComponents.getCompound(entry.getName())) == null && entry.isComponentBased()) {
                    throw new RuntimeException("Could not find vanilla components for vanilla component based item! " + entry.getName());
                }
                SimpleItemDefinition definition = new SimpleItemDefinition(entry.getName().intern(), id, ItemVersion.from((int)entry.getVersion()), entry.isComponentBased(), components);
                definitions.put(entry.getName(), definition);
                registry.put(definition.getRuntimeId(), (Object)definition);
            }
            Object2ObjectOpenHashMap bedrockBlockIdOverrides = new Object2ObjectOpenHashMap();
            Object2IntOpenHashMap blacklistedIdentifiers = new Object2IntOpenHashMap();
            Object2ObjectOpenHashMap customBlockItemDefinitions = new Object2ObjectOpenHashMap();
            ObjectArrayList buckets = new ObjectArrayList();
            ObjectArrayList mappings = new ObjectArrayList();
            Object2ObjectOpenHashMap javaItemToMapping = new Object2ObjectOpenHashMap();
            ArrayList<CreativeItemData> creativeItems = new ArrayList<CreativeItemData>();
            ObjectOpenHashSet noBlockDefinitions = new ObjectOpenHashSet();
            noBlockDefinitions.add("minecraft:structure_block");
            noBlockDefinitions.add("minecraft:structure_void");
            AtomicInteger creativeNetId = new AtomicInteger();
            CreativeItemRegistryPopulator.populate(palette, (Map<String, ItemDefinition>)definitions, items, (arg_0, arg_1) -> ItemRegistryPopulator.lambda$populate$2(creativeNetId, creativeItems, (Object2IntMap)blacklistedIdentifiers, (Object2ObjectMap)bedrockBlockIdOverrides, (Set)noBlockDefinitions, arg_0, arg_1));
            List<Object> creativeItemGroups = GameProtocol.isPreCreativeInventoryRewrite(palette.protocolVersion) ? new ArrayList() : CreativeItemRegistryPopulator.readCreativeItemGroups(palette, creativeItems);
            BlockMappings blockMappings = BlockRegistries.BLOCKS.forVersion(palette.protocolVersion());
            ObjectOpenHashSet javaOnlyItems = new ObjectOpenHashSet();
            Collections.addAll(javaOnlyItems, new Item[]{Items.SPECTRAL_ARROW, Items.DEBUG_STICK, Items.KNOWLEDGE_BOOK, Items.TIPPED_ARROW});
            if (!customItemsAllowed) {
                javaOnlyItems.add(Items.FURNACE_MINECART);
            }
            javaOnlyItems.addAll(palette.javaOnlyItems().keySet());
            Int2ObjectOpenHashMap customIdMappings = new Int2ObjectOpenHashMap();
            ObjectOpenHashSet registeredItemNames = new ObjectOpenHashSet();
            for (Map.Entry<String, GeyserMappingItem> entry : items.entrySet()) {
                ObjectArrayList customItemOptions;
                Object bedrockBlock;
                Object definition;
                String bedrockIdentifier;
                GeyserMappingItem mappingItem;
                Item javaItem;
                block68: {
                    Object blockTag;
                    int aValidBedrockBlockId;
                    CustomBlockData customBlockData;
                    BlockDefinition customBlockItemOverride;
                    Integer firstBlockRuntimeId;
                    block70: {
                        block69: {
                            javaItem = (Item)Registries.JAVA_ITEM_IDENTIFIERS.get(entry.getKey());
                            if (javaItem == null) {
                                throw new RuntimeException("Extra item in mappings? " + entry.getKey());
                            }
                            Item replacementItem = palette.javaOnlyItems().get(javaItem);
                            mappingItem = replacementItem != null ? items.get(replacementItem.javaIdentifier()) : palette.remapper().remap(javaItem, entry.getValue());
                            if (customItemsAllowed && javaItem == Items.FURNACE_MINECART) {
                                mappings.add(null);
                                continue;
                            }
                            bedrockIdentifier = mappingItem.getBedrockIdentifier();
                            definition = (ItemDefinition)definitions.get(bedrockIdentifier);
                            if (definition == null) {
                                throw new RuntimeException("Missing Bedrock ItemDefinition in version " + palette.version() + " for mapping: " + String.valueOf(mappingItem));
                            }
                            bedrockBlock = null;
                            firstBlockRuntimeId = entry.getValue().getFirstBlockRuntimeId();
                            customBlockItemOverride = null;
                            if (firstBlockRuntimeId == null) break block68;
                            GeyserBedrockBlock[] blockOverride = (GeyserBedrockBlock[])bedrockBlockIdOverrides.get((Object)bedrockIdentifier);
                            customBlockData = BlockRegistries.CUSTOM_BLOCK_ITEM_OVERRIDES.getOrDefault(javaItem.javaIdentifier(), null);
                            if (customBlockData != null && customBlockData.includedInCreativeInventory()) {
                                CustomBlockState customBlockState = customBlockData.defaultBlockState();
                                customBlockItemOverride = (BlockDefinition)blockMappings.getCustomBlockStateDefinitions().getOrDefault((Object)customBlockState, null);
                            }
                            if (blockOverride == null || customBlockItemOverride != null) break block69;
                            bedrockBlock = blockOverride;
                            break block68;
                        }
                        aValidBedrockBlockId = blacklistedIdentifiers.getOrDefault((Object)bedrockIdentifier, customBlockItemOverride != null ? customBlockItemOverride.getRuntimeId() : -1);
                        if (aValidBedrockBlockId != -1 || customBlockItemOverride != null) break block70;
                        if (noBlockDefinitions.contains(entry.getValue().getBedrockIdentifier())) break block68;
                        bedrockBlock = blockMappings.getBedrockBlock(firstBlockRuntimeId);
                        break block68;
                    }
                    NbtMapBuilder requiredBlockStatesBuilder = NbtMap.builder();
                    String correctBedrockIdentifier = blockMappings.getDefinition(aValidBedrockBlockId).getState().getString("name");
                    boolean firstPass = true;
                    int lastBlockRuntimeId = entry.getValue().getLastBlockRuntimeId() == null ? firstBlockRuntimeId : entry.getValue().getLastBlockRuntimeId();
                    for (int i = firstBlockRuntimeId.intValue(); i <= lastBlockRuntimeId; ++i) {
                        GeyserBedrockBlock[] bedrockBlockRuntimeId = blockMappings.getVanillaBedrockBlock(i);
                        NbtMap blockTag2 = bedrockBlockRuntimeId.getState();
                        String bedrockName = blockTag2.getString("name");
                        if (!bedrockName.equals(correctBedrockIdentifier)) continue;
                        NbtMap states = blockTag2.getCompound("states");
                        if (firstPass) {
                            firstPass = false;
                            if (states.isEmpty()) {
                                bedrockBlock = bedrockBlockRuntimeId;
                                break;
                            }
                            requiredBlockStatesBuilder.putAll((Map)states);
                            continue;
                        }
                        for (Map.Entry nbtEntry : states.entrySet()) {
                            Object value = requiredBlockStatesBuilder.get(nbtEntry.getKey());
                            if (value == null || nbtEntry.getValue().equals(value)) continue;
                            requiredBlockStatesBuilder.remove(nbtEntry.getKey());
                        }
                        if (requiredBlockStatesBuilder.isEmpty()) break;
                    }
                    NbtMap requiredBlockStates = requiredBlockStatesBuilder.build();
                    if (bedrockBlock == null) {
                        for (GeyserBedrockBlock block : blockMappings.getBedrockRuntimeMap()) {
                            if (block == null || !(blockTag = block.getState()).getString("name").equals(correctBedrockIdentifier)) continue;
                            NbtMap states = blockTag.getCompound("states");
                            boolean valid = true;
                            for (Map.Entry nbtEntry : requiredBlockStates.entrySet()) {
                                if (states.get(nbtEntry.getKey()).equals(nbtEntry.getValue())) continue;
                                valid = false;
                                break;
                            }
                            if (!valid) continue;
                            bedrockBlock = block;
                            break;
                        }
                        if (bedrockBlock == null) {
                            throw new RuntimeException("Could not find a block match for " + entry.getKey());
                        }
                    }
                    if (customBlockItemOverride != null) {
                        bedrockBlock = customBlockItemOverride;
                    }
                    for (int j = 0; j < creativeItems.size(); ++j) {
                        CreativeItemData itemData = (CreativeItemData)creativeItems.get(j);
                        if (!itemData.getItem().getDefinition().equals(definition)) continue;
                        if (itemData.getItem().getDamage() != 0) break;
                        NbtMap states = ((GeyserBedrockBlock)itemData.getItem().getBlockDefinition()).getState().getCompound("states");
                        boolean valid = true;
                        blockTag = requiredBlockStates.entrySet().iterator();
                        while (blockTag.hasNext()) {
                            Map.Entry nbtEntry;
                            nbtEntry = (Map.Entry)blockTag.next();
                            if (Objects.equals(states.get(nbtEntry.getKey()), nbtEntry.getValue())) continue;
                            valid = false;
                            break;
                        }
                        if (!valid) continue;
                        if (customBlockItemOverride != null && customBlockData != null) {
                            int customProtocolId = nextFreeBedrockId++;
                            mappingItem = mappingItem.withBedrockData(customProtocolId);
                            bedrockIdentifier = customBlockData.identifier();
                            definition = new SimpleItemDefinition(bedrockIdentifier, customProtocolId, ItemVersion.DATA_DRIVEN, true, NbtMap.EMPTY);
                            registry.put(customProtocolId, definition);
                            customBlockItemDefinitions.put((Object)customBlockData, definition);
                            customIdMappings.put(customProtocolId, (Object)bedrockIdentifier);
                            CreativeItemData newData = new CreativeItemData(itemData.getItem().toBuilder().definition((ItemDefinition)definition).blockDefinition((BlockDefinition)bedrockBlock).netId(itemData.getNetId()).count(1).build(), itemData.getNetId(), 0);
                            creativeItems.set(j, newData);
                            break;
                        }
                        CreativeItemData creativeItemData = new CreativeItemData(itemData.getItem().toBuilder().blockDefinition((BlockDefinition)bedrockBlock).build(), itemData.getNetId(), 0);
                        creativeItems.set(j, creativeItemData);
                        break;
                    }
                }
                ItemMapping.ItemMappingBuilder mappingBuilder = ItemMapping.builder().bedrockIdentifier(bedrockIdentifier.intern()).bedrockDefinition((ItemDefinition)definition).bedrockData(mappingItem.getBedrockData()).bedrockBlockDefinition((BlockDefinition)bedrockBlock).javaItem(javaItem);
                if (mappingItem.getToolType() != null) {
                    mappingBuilder = mappingBuilder.toolType(mappingItem.getToolType().intern());
                }
                if (javaOnlyItems.contains(javaItem)) {
                    mappingBuilder = mappingBuilder.translationString((javaItem instanceof BlockItem ? "block." : "item.") + entry.getKey().replace(":", "."));
                    GeyserImpl.getInstance().getLogger().debug("Adding " + entry.getKey() + " as an item that needs to be translated.");
                }
                Collection customItemsToLoad = customItems.get((Object)javaItem.javaIdentifier());
                if (customItemsAllowed && !customItemsToLoad.isEmpty()) {
                    customItemOptions = new ObjectArrayList(customItemsToLoad.size());
                    for (CustomItemData customItem : customItemsToLoad) {
                        String customItemName;
                        int customProtocolId = nextFreeBedrockId++;
                        if (customItem instanceof NonVanillaCustomItemData) {
                            NonVanillaCustomItemData nonVanillaItem = (NonVanillaCustomItemData)customItem;
                            v1 = nonVanillaItem.identifier();
                        } else {
                            v1 = customItemName = "geyser_custom:" + customItem.name();
                        }
                        if (!registeredItemNames.add(customItemName)) {
                            if (!firstMappingsPass) continue;
                            GeyserImpl.getInstance().getLogger().error("Custom item name '" + customItemName + "' already exists and was registered again! Skipping...");
                            continue;
                        }
                        GeyserCustomMappingData customMapping = CustomItemRegistryPopulator.registerCustomItem(customItemName, javaItem, mappingItem, customItem, customProtocolId, palette.protocolVersion);
                        if (customItem.creativeCategory().isPresent()) {
                            CreativeItemData creativeItemData = new CreativeItemData(ItemData.builder().netId(creativeNetId.incrementAndGet()).definition(customMapping.itemDefinition()).blockDefinition(null).count(1).build(), creativeNetId.get(), customItem.creativeCategory().getAsInt());
                            creativeItems.add(creativeItemData);
                        }
                        componentItemData.add(customMapping.itemDefinition());
                        customItemOptions.add(Pair.of((Object)customItem.customItemOptions(), (Object)customMapping.itemDefinition()));
                        registry.put(customMapping.integerId(), (Object)customMapping.itemDefinition());
                        customIdMappings.put(customMapping.integerId(), (Object)customMapping.stringId());
                    }
                    Collections.reverse(customItemOptions);
                } else {
                    customItemOptions = Collections.emptyList();
                }
                mappingBuilder.customItemOptions((List<Pair<CustomItemOptions, ItemDefinition>>)customItemOptions);
                ItemMapping mapping2 = mappingBuilder.build();
                if (javaItem.javaIdentifier().contains("bucket") && !javaItem.javaIdentifier().contains("milk")) {
                    buckets.add(definition);
                }
                mappings.add(mapping2);
                javaItemToMapping.put(javaItem, mapping2);
            }
            Int2ObjectOpenHashMap lightBlocks = new Int2ObjectOpenHashMap();
            for (int i = 0; i <= Properties.LEVEL.high() && (lightBlock = (ItemDefinition)definitions.get("minecraft:light_block_" + i)) != null; ++i) {
                ItemMapping lightBlockEntry = ItemMapping.builder().javaItem(Items.LIGHT).bedrockIdentifier("minecraft:light_block_" + i).bedrockDefinition(lightBlock).bedrockData(0).bedrockBlockDefinition(null).customItemOptions(Collections.emptyList()).build();
                lightBlocks.put(lightBlock.getRuntimeId(), (Object)lightBlockEntry);
            }
            ItemDefinition lodestoneCompass = (ItemDefinition)definitions.get("minecraft:lodestone_compass");
            if (lodestoneCompass == null) {
                throw new RuntimeException("Lodestone compass not found in item palette!");
            }
            ItemMapping lodestoneEntry = ItemMapping.builder().javaItem(Items.COMPASS).bedrockIdentifier("minecraft:lodestone_compass").bedrockDefinition(lodestoneCompass).bedrockData(0).bedrockBlockDefinition(null).customItemOptions(Collections.emptyList()).build();
            if (customItemsAllowed) {
                int furnaceMinecartId = nextFreeBedrockId++;
                SimpleItemDefinition definition = new SimpleItemDefinition("geysermc:furnace_minecart", furnaceMinecartId, ItemVersion.DATA_DRIVEN, true, ItemRegistryPopulator.registerFurnaceMinecart(furnaceMinecartId));
                definitions.put("geysermc:furnace_minecart", definition);
                registry.put(definition.getRuntimeId(), (Object)definition);
                componentItemData.add(definition);
                mappings.set(Items.FURNACE_MINECART.javaId(), ItemMapping.builder().javaItem(Items.FURNACE_MINECART).bedrockIdentifier("geysermc:furnace_minecart").bedrockDefinition((ItemDefinition)definition).bedrockData(0).bedrockBlockDefinition(null).customItemOptions(Collections.emptyList()).build());
                creativeItems.add(new CreativeItemData(ItemData.builder().usingNetId(true).netId(creativeNetId.incrementAndGet()).definition((ItemDefinition)definition).count(1).build(), creativeNetId.get(), 99));
                IntOpenHashSet registeredJavaIds = new IntOpenHashSet();
                for (NonVanillaCustomItemData customItem : nonVanillaCustomItems) {
                    if (!registeredJavaIds.add(customItem.javaId())) {
                        if (!firstMappingsPass) continue;
                        GeyserImpl.getInstance().getLogger().error("Custom item java id " + customItem.javaId() + " already exists and was registered again! Skipping...");
                        continue;
                    }
                    int customItemId = nextFreeBedrockId++;
                    NonVanillaItemRegistration registration = CustomItemRegistryPopulator.registerCustomItem(customItem, customItemId, palette.protocolVersion);
                    componentItemData.add(registration.mapping().getBedrockDefinition());
                    ItemMapping mapping3 = registration.mapping();
                    Item javaItem = registration.javaItem();
                    while (javaItem.javaId() >= mappings.size()) {
                        mappings.add(ItemMapping.AIR);
                    }
                    mappings.set(javaItem.javaId(), mapping3);
                    registry.put(customItemId, (Object)mapping3.getBedrockDefinition());
                    if (!customItem.creativeCategory().isPresent()) continue;
                    CreativeItemData creativeItemData = new CreativeItemData(ItemData.builder().definition(registration.mapping().getBedrockDefinition()).netId(creativeNetId.incrementAndGet()).count(1).build(), creativeNetId.get(), customItem.creativeCategory().getAsInt());
                    creativeItems.add(creativeItemData);
                }
            }
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                for (CustomBlockData customBlock : (CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()) {
                    if (customBlockItemDefinitions.containsKey((Object)customBlock) || customBlock instanceof NonVanillaCustomBlockData) continue;
                    int customProtocolId = nextFreeBedrockId++;
                    String identifier = customBlock.identifier();
                    SimpleItemDefinition definition = new SimpleItemDefinition(identifier, customProtocolId, ItemVersion.NONE, false, null);
                    registry.put(customProtocolId, (Object)definition);
                    customBlockItemDefinitions.put((Object)customBlock, (Object)definition);
                    customIdMappings.put(customProtocolId, (Object)identifier);
                    GeyserBedrockBlock bedrockBlock = (GeyserBedrockBlock)blockMappings.getCustomBlockStateDefinitions().getOrDefault((Object)customBlock.defaultBlockState(), null);
                    if (bedrockBlock == null || !customBlock.includedInCreativeInventory()) continue;
                    CreativeItemData creativeItemData = new CreativeItemData(ItemData.builder().definition((ItemDefinition)definition).blockDefinition((BlockDefinition)bedrockBlock).netId(creativeNetId.incrementAndGet()).count(1).build(), creativeNetId.get(), customBlock.creativeCategory().id());
                    creativeItems.add(creativeItemData);
                }
            }
            ItemMappings itemMappings = ItemMappings.builder().items(mappings.toArray(new ItemMapping[0])).creativeItems(creativeItems).creativeItemGroups(creativeItemGroups).itemDefinitions((Int2ObjectMap<ItemDefinition>)registry).componentItemData((List<ItemDefinition>)componentItemData).storedItems(new StoredItemMappings((Map<Item, ItemMapping>)javaItemToMapping)).javaOnlyItems((Set<Item>)javaOnlyItems).buckets((List<ItemDefinition>)buckets).lightBlocks((Int2ObjectMap<ItemMapping>)lightBlocks).lodestoneCompass(lodestoneEntry).customIdMappings((Int2ObjectMap<String>)customIdMappings).customBlockItemDefinitions((Object2ObjectMap<CustomBlockData, ItemDefinition>)customBlockItemDefinitions).build();
            Registries.ITEMS.register(palette.protocolVersion(), itemMappings);
            firstMappingsPass = false;
        }
    }

    private static NbtMap registerFurnaceMinecart(int nextFreeBedrockId) {
        NbtMapBuilder builder = NbtMap.builder();
        builder.putString("name", "geysermc:furnace_minecart").putInt("id", nextFreeBedrockId);
        NbtMapBuilder itemProperties = NbtMap.builder();
        NbtMapBuilder componentBuilder = NbtMap.builder();
        NbtMap iconMap = NbtMap.builder().putCompound("textures", NbtMap.builder().putString("default", "minecart_furnace").build()).build();
        itemProperties.putCompound("minecraft:icon", iconMap);
        componentBuilder.putCompound("minecraft:display_name", NbtMap.builder().putString("value", "item.minecartFurnace.name").build());
        List<NbtMap> useOnTag = Collections.singletonList(NbtMap.builder().putString("tags", "q.any_tag('rail')").build());
        componentBuilder.putCompound("minecraft:entity_placer", NbtMap.builder().putList("dispense_on", NbtType.COMPOUND, useOnTag).putString("entity", "minecraft:minecart").putList("use_on", NbtType.COMPOUND, useOnTag).build());
        itemProperties.putBoolean("allow_off_hand", true);
        itemProperties.putBoolean("hand_equipped", false);
        itemProperties.putInt("max_stack_size", 1);
        itemProperties.putString("creative_group", "itemGroup.name.minecart");
        itemProperties.putInt("creative_category", 4);
        componentBuilder.putCompound("item_properties", itemProperties.build());
        builder.putCompound("components", componentBuilder.build());
        return builder.build();
    }

    private static /* synthetic */ void lambda$populate$2(AtomicInteger creativeNetId, List creativeItems, Object2IntMap blacklistedIdentifiers, Object2ObjectMap bedrockBlockIdOverrides, Set noBlockDefinitions, ItemData.Builder itemBuilder, Integer groupId) {
        ItemData item = itemBuilder.netId(creativeNetId.incrementAndGet()).build();
        creativeItems.add(new CreativeItemData(item, item.getNetId(), groupId.intValue()));
        if (item.getBlockDefinition() != null) {
            String identifier = item.getDefinition().getIdentifier();
            if (!blacklistedIdentifiers.containsKey((Object)identifier)) {
                if (bedrockBlockIdOverrides.containsKey((Object)identifier)) {
                    bedrockBlockIdOverrides.remove((Object)identifier);
                    blacklistedIdentifiers.put((Object)identifier, item.getBlockDefinition().getRuntimeId());
                } else {
                    bedrockBlockIdOverrides.put((Object)identifier, (Object)item.getBlockDefinition());
                }
            }
        } else {
            noBlockDefinitions.add(item.getDefinition().getIdentifier());
        }
    }

    record PaletteVersion(String version, int protocolVersion, Map<Item, Item> javaOnlyItems, Remapper remapper) {
        public PaletteVersion(String version, int protocolVersion) {
            this(version, protocolVersion, Collections.emptyMap(), (item, mapping) -> mapping);
        }
    }

    @FunctionalInterface
    static interface Remapper {
        public @NonNull GeyserMappingItem remap(Item var1, GeyserMappingItem var2);
    }
}

