/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.velocity;

import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.network.ProtocolState;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.ping.GeyserPingInfo;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;

public class GeyserVelocityPingPassthrough
implements IGeyserPingPassthrough {
    private final ProxyServer server;

    @Override
    public GeyserPingInfo getPingInformation(InetSocketAddress inetSocketAddress) {
        ProxyPingEvent event;
        try {
            event = (ProxyPingEvent)this.server.getEventManager().fire((Object)new ProxyPingEvent((InboundConnection)new GeyserInboundConnection(inetSocketAddress), ServerPing.builder().description(this.server.getConfiguration().getMotd()).onlinePlayers(this.server.getPlayerCount()).maximumPlayers(this.server.getConfiguration().getShowMaxPlayers()).version(new ServerPing.Version(GameProtocol.getJavaProtocolVersion(), GameProtocol.getJavaMinecraftVersion())).build())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return new GeyserPingInfo((String)GsonComponentSerializer.gson().serialize(event.getPing().getDescriptionComponent()), event.getPing().getPlayers().map(ServerPing.Players::getMax).orElse(1), event.getPing().getPlayers().map(ServerPing.Players::getOnline).orElse(0));
    }

    public GeyserVelocityPingPassthrough(ProxyServer server) {
        this.server = server;
    }

    private static class GeyserInboundConnection
    implements InboundConnection {
        private final InetSocketAddress remote;

        public GeyserInboundConnection(InetSocketAddress remote) {
            this.remote = remote;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remote;
        }

        public Optional<InetSocketAddress> getVirtualHost() {
            return Optional.empty();
        }

        public boolean isActive() {
            return false;
        }

        public ProtocolVersion getProtocolVersion() {
            return ProtocolVersion.MAXIMUM_VERSION;
        }

        public ProtocolState getProtocolState() {
            return ProtocolState.STATUS;
        }
    }
}

