/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;
import org.jetbrains.annotations.Nullable;

public record JukeboxPlayable(@Nullable Holder<JukeboxSong> songHolder, @Nullable Key songLocation, boolean showInTooltip) {
    public static @NonNull JukeboxPlayableBuilder builder() {
        return new JukeboxPlayableBuilder();
    }

    public @NonNull JukeboxPlayableBuilder toBuilder() {
        return new JukeboxPlayableBuilder().songHolder(this.songHolder).songLocation(this.songLocation).showInTooltip(this.showInTooltip);
    }

    public static class JukeboxPlayableBuilder {
        private Holder<JukeboxSong> songHolder;
        private Key songLocation;
        private boolean showInTooltip;

        JukeboxPlayableBuilder() {
        }

        public @NonNull JukeboxPlayableBuilder songHolder(@Nullable Holder<JukeboxSong> songHolder) {
            this.songHolder = songHolder;
            return this;
        }

        public @NonNull JukeboxPlayableBuilder songLocation(@Nullable Key songLocation) {
            this.songLocation = songLocation;
            return this;
        }

        public @NonNull JukeboxPlayableBuilder showInTooltip(boolean showInTooltip) {
            this.showInTooltip = showInTooltip;
            return this;
        }

        public @NonNull JukeboxPlayable build() {
            return new JukeboxPlayable(this.songHolder, this.songLocation, this.showInTooltip);
        }

        public @NonNull String toString() {
            return "JukeboxPlayable.JukeboxPlayableBuilder(songHolder=" + String.valueOf(this.songHolder) + ", songLocation=" + String.valueOf(this.songLocation) + ", showInTooltip=" + this.showInTooltip + ")";
        }
    }

    public record JukeboxSong(Sound soundEvent, Component description, float lengthInSeconds, int comparatorOutput) {
        public static @NonNull JukeboxSongBuilder builder() {
            return new JukeboxSongBuilder();
        }

        public @NonNull JukeboxSongBuilder toBuilder() {
            return new JukeboxSongBuilder().soundEvent(this.soundEvent).description(this.description).lengthInSeconds(this.lengthInSeconds).comparatorOutput(this.comparatorOutput);
        }

        public static class JukeboxSongBuilder {
            private Sound soundEvent;
            private Component description;
            private float lengthInSeconds;
            private int comparatorOutput;

            JukeboxSongBuilder() {
            }

            public @NonNull JukeboxSongBuilder soundEvent(Sound soundEvent) {
                this.soundEvent = soundEvent;
                return this;
            }

            public @NonNull JukeboxSongBuilder description(Component description) {
                this.description = description;
                return this;
            }

            public @NonNull JukeboxSongBuilder lengthInSeconds(float lengthInSeconds) {
                this.lengthInSeconds = lengthInSeconds;
                return this;
            }

            public @NonNull JukeboxSongBuilder comparatorOutput(int comparatorOutput) {
                this.comparatorOutput = comparatorOutput;
                return this;
            }

            public @NonNull JukeboxSong build() {
                return new JukeboxSong(this.soundEvent, this.description, this.lengthInSeconds, this.comparatorOutput);
            }

            public @NonNull String toString() {
                return "JukeboxPlayable.JukeboxSong.JukeboxSongBuilder(soundEvent=" + String.valueOf(this.soundEvent) + ", description=" + String.valueOf(this.description) + ", lengthInSeconds=" + this.lengthInSeconds + ", comparatorOutput=" + this.comparatorOutput + ")";
            }
        }
    }
}

