/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.imaginary;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.imaginary.Complexd;
import org.cloudburstmc.math.imaginary.Imaginary;
import org.cloudburstmc.math.imaginary.Imaginaryd;
import org.cloudburstmc.math.imaginary.Quaternionf;
import org.cloudburstmc.math.matrix.Matrix3d;
import org.cloudburstmc.math.vector.Vector3d;

@ParametersAreNonnullByDefault
public abstract class Quaterniond
implements Imaginaryd,
Comparable<Quaterniond>,
Serializable,
Cloneable {
    public static final Quaterniond ZERO = Quaterniond.from(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Quaterniond IDENTITY = Quaterniond.from(0.0f, 0.0f, 0.0f, 1.0f);

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract double getW();

    @Nonnull
    public Quaterniond add(Quaterniond q) {
        return this.add(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    @Nonnull
    public Quaterniond add(float x, float y, float z, float w) {
        return this.add((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public abstract Quaterniond add(double var1, double var3, double var5, double var7);

    @Nonnull
    public Quaterniond sub(Quaterniond q) {
        return this.sub(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    @Nonnull
    public Quaterniond sub(float x, float y, float z, float w) {
        return this.sub((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public abstract Quaterniond sub(double var1, double var3, double var5, double var7);

    @Nonnull
    public Quaterniond mul(float a) {
        return this.mul((double)a);
    }

    @Override
    @Nonnull
    public abstract Quaterniond mul(double var1);

    @Nonnull
    public Quaterniond mul(Quaterniond q) {
        return this.mul(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    @Nonnull
    public Quaterniond mul(float x, float y, float z, float w) {
        return this.mul((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public abstract Quaterniond mul(double var1, double var3, double var5, double var7);

    @Nonnull
    public Quaterniond div(float a) {
        return this.div((double)a);
    }

    @Override
    @Nonnull
    public abstract Quaterniond div(double var1);

    @Nonnull
    public Quaterniond div(Quaterniond q) {
        return this.div(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    @Nonnull
    public Quaterniond div(float x, float y, float z, float w) {
        return this.div((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public abstract Quaterniond div(double var1, double var3, double var5, double var7);

    public double dot(Quaterniond q) {
        return this.dot(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    public double dot(float x, float y, float z, float w) {
        return this.dot((double)x, (double)y, (double)z, (double)w);
    }

    public double dot(double x, double y, double z, double w) {
        return this.getX() * x + this.getY() * y + this.getZ() * z + this.getW() * w;
    }

    @Nonnull
    public Vector3d rotate(Vector3d v) {
        return this.rotate(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3d rotate(float x, float y, float z) {
        return this.rotate((double)x, (double)y, (double)z);
    }

    @Nonnull
    public Vector3d rotate(double x, double y, double z) {
        double length = this.length();
        if (Math.abs(length) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot rotate by the zero quaternion");
        }
        double nx = this.getX() / length;
        double ny = this.getY() / length;
        double nz = this.getZ() / length;
        double nw = this.getW() / length;
        double px = nw * x + ny * z - nz * y;
        double py = nw * y + nz * x - nx * z;
        double pz = nw * z + nx * y - ny * x;
        double pw = -nx * x - ny * y - nz * z;
        return Vector3d.from(pw * -nx + px * nw - py * nz + pz * ny, pw * -ny + py * nw - pz * nx + px * nz, pw * -nz + pz * nw - px * ny + py * nx);
    }

    @Nonnull
    public Vector3d getDirection() {
        return this.rotate(Vector3d.FORWARD);
    }

    @Nonnull
    public Vector3d getAxis() {
        double q = Math.sqrt(1.0 - this.getW() * this.getW());
        return Vector3d.from(this.getX() / q, this.getY() / q, this.getZ() / q);
    }

    @Nonnull
    public Vector3d getAxesAnglesDeg() {
        return this.getAxesAnglesRad().mul(57.29577951308232);
    }

    @Nonnull
    public Vector3d getAxesAnglesRad() {
        double yaw;
        double pitch;
        double roll;
        double test = this.getW() * this.getX() - this.getY() * this.getZ();
        if (Math.abs(test) < 0.4999) {
            roll = TrigMath.atan2(2.0 * (this.getW() * this.getZ() + this.getX() * this.getY()), 1.0 - 2.0 * (this.getX() * this.getX() + this.getZ() * this.getZ()));
            pitch = TrigMath.asin(2.0 * test);
            yaw = TrigMath.atan2(2.0 * (this.getW() * this.getY() + this.getZ() * this.getX()), 1.0 - 2.0 * (this.getX() * this.getX() + this.getY() * this.getY()));
        } else {
            int sign = test < 0.0 ? -1 : 1;
            roll = 0.0;
            pitch = (double)sign * Math.PI / 2.0;
            yaw = (double)(-sign * 2) * TrigMath.atan2(this.getZ(), this.getW());
        }
        return Vector3d.from(pitch, yaw, roll);
    }

    @Override
    @Nonnull
    public abstract Quaterniond conjugate();

    @Override
    @Nonnull
    public abstract Quaterniond invert();

    @Override
    public double lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ() + this.getW() * this.getW();
    }

    @Override
    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public abstract Quaterniond normalize();

    @Nonnull
    public Complexd toComplex() {
        double w2 = this.getW() * this.getW();
        return Complexd.from(2.0 * w2 - 1.0, 2.0 * this.getW() * Math.sqrt(1.0 - w2));
    }

    @Override
    @Nonnull
    public Quaternionf toFloat() {
        return Quaternionf.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Quaterniond toDouble() {
        return Quaterniond.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    public int compareTo(Quaterniond q) {
        return (int)Math.signum(this.lengthSquared() - q.lengthSquared());
    }

    @Nonnull
    public Quaterniond clone() {
        return Quaterniond.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ", " + this.getW() + ")";
    }

    @Nonnull
    public static Quaterniond fromReal(double w) {
        return Imaginary.createQuaterniond(0.0, 0.0, 0.0, w);
    }

    @Nonnull
    public static Quaterniond fromImaginary(double x, double y, double z) {
        return Imaginary.createQuaterniond(x, y, z, 0.0);
    }

    public static Quaterniond from(Quaterniond q) {
        return Quaterniond.from(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    @Nonnull
    public static Quaterniond from(float x, float y, float z, float w) {
        return Quaterniond.from((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public static Quaterniond from(double x, double y, double z, double w) {
        return Imaginary.createQuaterniond(x, y, z, w);
    }

    @Nonnull
    public static Quaterniond fromAxesAnglesDeg(float pitch, float yaw, float roll) {
        return Quaterniond.fromAxesAnglesDeg((double)pitch, (double)yaw, (double)roll);
    }

    @Nonnull
    public static Quaterniond fromAxesAnglesRad(float pitch, float yaw, float roll) {
        return Quaterniond.fromAxesAnglesRad((double)pitch, (double)yaw, (double)roll);
    }

    @Nonnull
    public static Quaterniond fromAxesAnglesDeg(double pitch, double yaw, double roll) {
        return Quaterniond.fromAngleDegAxis(yaw, Vector3d.UNIT_Y).mul(Quaterniond.fromAngleDegAxis(pitch, Vector3d.UNIT_X)).mul(Quaterniond.fromAngleDegAxis(roll, Vector3d.UNIT_Z));
    }

    @Nonnull
    public static Quaterniond fromAxesAnglesRad(double pitch, double yaw, double roll) {
        return Quaterniond.fromAngleRadAxis(yaw, Vector3d.UNIT_Y).mul(Quaterniond.fromAngleRadAxis(pitch, Vector3d.UNIT_X)).mul(Quaterniond.fromAngleRadAxis(roll, Vector3d.UNIT_Z));
    }

    @Nonnull
    public static Quaterniond fromRotationTo(Vector3d from, Vector3d to) {
        return Quaterniond.fromAngleRadAxis(TrigMath.acos(from.dot(to) / (from.length() * to.length())), from.cross(to));
    }

    @Nonnull
    public static Quaterniond fromAngleDegAxis(float angle, Vector3d axis) {
        return Quaterniond.fromAngleRadAxis(Math.toRadians(angle), axis);
    }

    @Nonnull
    public static Quaterniond fromAngleRadAxis(float angle, Vector3d axis) {
        return Quaterniond.fromAngleRadAxis((double)angle, axis);
    }

    @Nonnull
    public static Quaterniond fromAngleDegAxis(double angle, Vector3d axis) {
        return Quaterniond.fromAngleRadAxis(Math.toRadians(angle), axis);
    }

    @Nonnull
    public static Quaterniond fromAngleRadAxis(double angle, Vector3d axis) {
        return Quaterniond.fromAngleRadAxis(angle, axis.getX(), axis.getY(), axis.getZ());
    }

    @Nonnull
    public static Quaterniond fromAngleDegAxis(float angle, float x, float y, float z) {
        return Quaterniond.fromAngleRadAxis(Math.toRadians(angle), (double)x, (double)y, (double)z);
    }

    @Nonnull
    public static Quaterniond fromAngleRadAxis(float angle, float x, float y, float z) {
        return Quaterniond.fromAngleRadAxis((double)angle, (double)x, (double)y, (double)z);
    }

    @Nonnull
    public static Quaterniond fromAngleDegAxis(double angle, double x, double y, double z) {
        return Quaterniond.fromAngleRadAxis(Math.toRadians(angle), x, y, z);
    }

    @Nonnull
    public static Quaterniond fromAngleRadAxis(double angle, double x, double y, double z) {
        double halfAngle = angle / 2.0;
        double q = (double)TrigMath.sin(halfAngle) / Math.sqrt(x * x + y * y + z * z);
        return Quaterniond.from(x * q, y * q, z * q, (double)TrigMath.cos(halfAngle));
    }

    @Nonnull
    public static Quaterniond fromRotationMatrix(Matrix3d matrix) {
        double trace = matrix.trace();
        if (trace < 0.0) {
            if (matrix.get(1, 1) > matrix.get(0, 0)) {
                if (matrix.get(2, 2) > matrix.get(1, 1)) {
                    double r = Math.sqrt(matrix.get(2, 2) - matrix.get(0, 0) - matrix.get(1, 1) + 1.0);
                    double s2 = 0.5 / r;
                    return Quaterniond.from((matrix.get(2, 0) + matrix.get(0, 2)) * s2, (matrix.get(1, 2) + matrix.get(2, 1)) * s2, 0.5 * r, (matrix.get(1, 0) - matrix.get(0, 1)) * s2);
                }
                double r = Math.sqrt(matrix.get(1, 1) - matrix.get(2, 2) - matrix.get(0, 0) + 1.0);
                double s3 = 0.5 / r;
                return Quaterniond.from((matrix.get(0, 1) + matrix.get(1, 0)) * s3, 0.5 * r, (matrix.get(1, 2) + matrix.get(2, 1)) * s3, (matrix.get(0, 2) - matrix.get(2, 0)) * s3);
            }
            if (matrix.get(2, 2) > matrix.get(0, 0)) {
                double r = Math.sqrt(matrix.get(2, 2) - matrix.get(0, 0) - matrix.get(1, 1) + 1.0);
                double s4 = 0.5 / r;
                return Quaterniond.from((matrix.get(2, 0) + matrix.get(0, 2)) * s4, (matrix.get(1, 2) + matrix.get(2, 1)) * s4, 0.5 * r, (matrix.get(1, 0) - matrix.get(0, 1)) * s4);
            }
            double r = Math.sqrt(matrix.get(0, 0) - matrix.get(1, 1) - matrix.get(2, 2) + 1.0);
            double s5 = 0.5 / r;
            return Quaterniond.from(0.5 * r, (matrix.get(0, 1) + matrix.get(1, 0)) * s5, (matrix.get(2, 0) - matrix.get(0, 2)) * s5, (matrix.get(2, 1) - matrix.get(1, 2)) * s5);
        }
        double r = Math.sqrt(trace + 1.0);
        double s6 = 0.5 / r;
        return Quaterniond.from((matrix.get(2, 1) - matrix.get(1, 2)) * s6, (matrix.get(0, 2) - matrix.get(2, 0)) * s6, (matrix.get(1, 0) - matrix.get(0, 1)) * s6, 0.5 * r);
    }
}

