/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.channel.raknet;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFactory;
import io.netty.channel.socket.DatagramChannel;
import io.netty.util.internal.StringUtil;
import java.lang.reflect.Constructor;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.cloudburstmc.netty.channel.raknet.RakChannel;
import org.cloudburstmc.netty.channel.raknet.RakClientChannel;
import org.cloudburstmc.netty.channel.raknet.RakServerChannel;

public class RakChannelFactory<T extends Channel>
implements ChannelFactory<T> {
    private final Class<T> channelClass;
    private final Function<DatagramChannel, T> constructor;
    private final Constructor<? extends DatagramChannel> datagramConstructor;
    private final Consumer<DatagramChannel> parentConsumer;

    private RakChannelFactory(Class<T> channelClass, Function<DatagramChannel, T> constructor, Class<? extends DatagramChannel> datagramClass, Consumer<DatagramChannel> parentConsumer) {
        Objects.requireNonNull(channelClass, "channelClass");
        Objects.requireNonNull(datagramClass, "datagramClass");
        Objects.requireNonNull(constructor, "constructor");
        this.channelClass = channelClass;
        this.constructor = constructor;
        try {
            this.datagramConstructor = datagramClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + StringUtil.simpleClassName(datagramClass) + " does not have a public non-arg constructor", e);
        }
        this.parentConsumer = parentConsumer;
    }

    public static RakChannelFactory<RakServerChannel> server(Class<? extends DatagramChannel> clazz) {
        return new RakChannelFactory<RakServerChannel>(RakServerChannel.class, RakServerChannel::new, clazz, null);
    }

    public static RakChannelFactory<RakServerChannel> server(Class<? extends DatagramChannel> clazz, Consumer<DatagramChannel> parentConsumer) {
        return new RakChannelFactory<RakServerChannel>(RakServerChannel.class, RakServerChannel::new, clazz, parentConsumer);
    }

    public static RakChannelFactory<RakServerChannel> server(Class<? extends DatagramChannel> clazz, Consumer<DatagramChannel> parentConsumer, Consumer<RakChannel> childConsumer) {
        return new RakChannelFactory<RakServerChannel>(RakServerChannel.class, ch -> new RakServerChannel((DatagramChannel)ch, childConsumer), clazz, parentConsumer);
    }

    public static RakChannelFactory<RakClientChannel> client(Class<? extends DatagramChannel> clazz) {
        return new RakChannelFactory<RakClientChannel>(RakClientChannel.class, RakClientChannel::new, clazz, null);
    }

    public static RakChannelFactory<RakClientChannel> client(Class<? extends DatagramChannel> clazz, Consumer<DatagramChannel> parentConsumer) {
        return new RakChannelFactory<RakClientChannel>(RakClientChannel.class, RakClientChannel::new, clazz, parentConsumer);
    }

    public T newChannel() {
        try {
            DatagramChannel channel = this.datagramConstructor.newInstance(new Object[0]);
            if (this.parentConsumer != null) {
                this.parentConsumer.accept(channel);
            }
            return (T)((Channel)this.constructor.apply(channel));
        }
        catch (Throwable t2) {
            throw new ChannelException("Unable to create Channel from class " + this.channelClass, t2);
        }
    }

    public String toString() {
        return StringUtil.simpleClassName(RakChannelFactory.class) + '(' + StringUtil.simpleClassName(this.channelClass) + ".class, " + StringUtil.simpleClassName(this.datagramConstructor.getDeclaringClass()) + ".class)";
    }
}

