/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.item.TooltipOptions;
import org.geysermc.geyser.item.type.FireworkRocketItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Fireworks;

public class FireworkStarItem
extends Item {
    public FireworkStarItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull TooltipOptions tooltip, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, tooltip, builder);
        Fireworks.FireworkExplosion explosion = components.get(DataComponentTypes.FIREWORK_EXPLOSION);
        if (explosion != null) {
            NbtMap newExplosion = FireworkRocketItem.translateExplosionToBedrock(explosion);
            builder.putCompound("FireworksItem", newExplosion);
            int[] colors = explosion.getColors();
            if (colors.length != 0) {
                int finalColor;
                if (colors.length == 1) {
                    finalColor = colors[0];
                } else {
                    int r = 0;
                    int g2 = 0;
                    int b = 0;
                    for (int fireworkColor : colors) {
                        r += (fireworkColor & 0xFF0000) >> 16;
                        g2 += (fireworkColor & 0xFF00) >> 8;
                        b += fireworkColor & 0xFF;
                    }
                    finalColor = (r /= colors.length) << 16 | (g2 /= colors.length) << 8 | (b /= colors.length);
                }
                builder.putInt("customColor", finalColor);
            }
        }
    }

    @Override
    public void translateNbtToJava(@NonNull GeyserSession session, @NonNull NbtMap bedrockTag, @NonNull DataComponents components, @NonNull ItemMapping mapping) {
        super.translateNbtToJava(session, bedrockTag, components, mapping);
        NbtMap explosion = bedrockTag.getCompound("FireworksItem");
        if (!explosion.isEmpty()) {
            Fireworks.FireworkExplosion newExplosion = FireworkRocketItem.translateExplosionToJava(explosion);
            if (newExplosion == null) {
                return;
            }
            components.put(DataComponentTypes.FIREWORK_EXPLOSION, newExplosion);
        }
    }

    @Override
    public boolean ignoreDamage() {
        return true;
    }
}

