/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.HSVLike;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum FireworkColor {
    BLACK(0x1E1B1B),
    RED(11743532),
    GREEN(3887386),
    BROWN(5320730),
    BLUE(2437522),
    PURPLE(8073150),
    CYAN(2651799),
    LIGHT_GRAY(0xABABAB),
    GRAY(0x434343),
    PINK(14188952),
    LIME(4312372),
    YELLOW(14602026),
    LIGHT_BLUE(6719955),
    MAGENTA(12801229),
    ORANGE(15435844),
    WHITE(0xF0F0F0);

    private static final FireworkColor[] VALUES;
    private final TextColor color;

    private FireworkColor(int rgbValue) {
        this.color = TextColor.color((int)rgbValue);
    }

    private static HSVLike toHSV(int rgbValue) {
        int r = (rgbValue & 0xFF0000) >> 16;
        int g2 = (rgbValue & 0xFF00) >> 8;
        int b = rgbValue & 0xFF;
        return HSVLike.fromRGB((int)r, (int)g2, (int)b);
    }

    public static byte fromJavaRGB(int rgbValue) {
        HSVLike hsv = FireworkColor.toHSV(rgbValue);
        return (byte)FireworkColor.nearestTo(hsv).ordinal();
    }

    private static @NonNull FireworkColor nearestTo(HSVLike any) {
        float matchedDistance = Float.MAX_VALUE;
        FireworkColor match = VALUES[0];
        for (FireworkColor potential : VALUES) {
            float distance = FireworkColor.distance(any, potential.color.asHSV());
            if (distance < matchedDistance) {
                match = potential;
                matchedDistance = distance;
            }
            if (distance == 0.0f) break;
        }
        return match;
    }

    private static float distance(HSVLike self, HSVLike other) {
        float hueDistance = 3.0f * Math.min(Math.abs(self.h() - other.h()), 1.0f - Math.abs(self.h() - other.h()));
        float saturationDiff = self.s() - other.s();
        float valueDiff = self.v() - other.v();
        return hueDistance * hueDistance + saturationDiff * saturationDiff + valueDiff * valueDiff;
    }

    public static int fromBedrockId(int id) {
        for (FireworkColor fireworkColor : VALUES) {
            if (fireworkColor.ordinal() != id) continue;
            return fireworkColor.color.value();
        }
        return FireworkColor.WHITE.color.value();
    }

    static {
        VALUES = FireworkColor.values();
    }
}

