/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector3f;

public class MathUtils {
    public static final double SQRT_OF_TWO = Math.sqrt(2.0);

    public static Vector3f xYRot(Vector3f velocity, float pitch, float yaw) {
        float pitchCos = TrigMath.cos(pitch);
        float pitchSin = TrigMath.sin(pitch);
        float yawCos = TrigMath.cos(yaw);
        float yawSin = TrigMath.sin(yaw);
        float e = velocity.getY() * pitchCos + velocity.getZ() * pitchSin;
        float i = velocity.getZ() * pitchCos - velocity.getY() * pitchSin;
        velocity = Vector3f.from(velocity.getX(), e, i);
        float d1 = velocity.getX() * yawCos + velocity.getZ() * yawSin;
        float i1 = velocity.getZ() * yawCos - velocity.getX() * yawSin;
        return Vector3f.from(d1, e, i1);
    }

    public static float wrapDegrees(float degrees2) {
        if ((degrees2 %= 360.0f) < -180.0f) {
            degrees2 += 360.0f;
        } else if (degrees2 >= 180.0f) {
            degrees2 -= 360.0f;
        }
        return degrees2;
    }

    public static float wrapDegrees(double degrees2) {
        return MathUtils.wrapDegrees((float)degrees2);
    }

    public static int wrapDegreesToInt(float degrees2) {
        return (int)MathUtils.wrapDegrees(degrees2);
    }

    public static float unwrapDegrees(float degrees2) {
        return (degrees2 % 360.0f + 360.0f) % 360.0f;
    }

    public static float unwrapDegrees(double degrees2) {
        return MathUtils.unwrapDegrees((float)degrees2);
    }

    public static int unwrapDegreesToInt(float degrees2) {
        return (int)MathUtils.unwrapDegrees(degrees2);
    }

    public static int ceil(float floatNumber) {
        int truncated = (int)floatNumber;
        return floatNumber > (float)truncated ? truncated + 1 : truncated;
    }

    public static double constrain(double num, double min2, double max) {
        if (num > max) {
            num = max;
        }
        if (num < min2) {
            num = min2;
        }
        return num;
    }

    public static int constrain(int num, int min2, int max) {
        if (num > max) {
            num = max;
        }
        if (num < min2) {
            num = min2;
        }
        return num;
    }

    public static float clamp(float value, float low, float high) {
        if (value < low) {
            return low;
        }
        if (value > high) {
            return high;
        }
        return value;
    }

    public static long chunkPositionToLong(int x, int z) {
        return ((long)x & 0xFFFFFFFFL) << 32 | (long)z & 0xFFFFFFFFL;
    }
}

