/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.command.properties;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.command.properties.CommandProperties;

public class DoubleProperties
implements CommandProperties {
    private final double min;
    private final double max;

    public DoubleProperties() {
        this.min = -1.7976931348623157E308;
        this.max = Double.MAX_VALUE;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleProperties)) {
            return false;
        }
        DoubleProperties other = (DoubleProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMin(), other.getMin()) != 0) {
            return false;
        }
        return Double.compare(this.getMax(), other.getMax()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DoubleProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $min = Double.doubleToLongBits(this.getMin());
        result = result * 59 + (int)($min >>> 32 ^ $min);
        long $max = Double.doubleToLongBits(this.getMax());
        result = result * 59 + (int)($max >>> 32 ^ $max);
        return result;
    }

    public @NonNull String toString() {
        return "DoubleProperties(min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }

    public DoubleProperties(double min2, double max) {
        this.min = min2;
        this.max = max;
    }
}

